package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeregisterContainerInstanceResponse(
    containerInstance: Option[zio.aws.ecs.model.ContainerInstance] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DeregisterContainerInstanceResponse = {
    import DeregisterContainerInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DeregisterContainerInstanceResponse
      .builder()
      .optionallyWith(containerInstance.map(value => value.buildAwsValue()))(
        _.containerInstance
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ecs.model.DeregisterContainerInstanceResponse.ReadOnly =
    zio.aws.ecs.model.DeregisterContainerInstanceResponse.wrap(buildAwsValue())
}
object DeregisterContainerInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DeregisterContainerInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DeregisterContainerInstanceResponse =
      zio.aws.ecs.model.DeregisterContainerInstanceResponse(
        containerInstance.map(value => value.asEditable)
      )
    def containerInstance: Option[zio.aws.ecs.model.ContainerInstance.ReadOnly]
    def getContainerInstance
        : ZIO[Any, AwsError, zio.aws.ecs.model.ContainerInstance.ReadOnly] =
      AwsError.unwrapOptionField("containerInstance", containerInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DeregisterContainerInstanceResponse
  ) extends zio.aws.ecs.model.DeregisterContainerInstanceResponse.ReadOnly {
    override val containerInstance
        : Option[zio.aws.ecs.model.ContainerInstance.ReadOnly] = scala
      .Option(impl.containerInstance())
      .map(value => zio.aws.ecs.model.ContainerInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DeregisterContainerInstanceResponse
  ): zio.aws.ecs.model.DeregisterContainerInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
