package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RuntimePlatform(
    cpuArchitecture: Option[zio.aws.ecs.model.CPUArchitecture] = None,
    operatingSystemFamily: Option[zio.aws.ecs.model.OSFamily] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.RuntimePlatform = {
    import RuntimePlatform.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.RuntimePlatform
      .builder()
      .optionallyWith(cpuArchitecture.map(value => value.unwrap))(
        _.cpuArchitecture
      )
      .optionallyWith(operatingSystemFamily.map(value => value.unwrap))(
        _.operatingSystemFamily
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.RuntimePlatform.ReadOnly =
    zio.aws.ecs.model.RuntimePlatform.wrap(buildAwsValue())
}
object RuntimePlatform {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.RuntimePlatform
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.RuntimePlatform =
      zio.aws.ecs.model.RuntimePlatform(
        cpuArchitecture.map(value => value),
        operatingSystemFamily.map(value => value)
      )
    def cpuArchitecture: Option[zio.aws.ecs.model.CPUArchitecture]
    def operatingSystemFamily: Option[zio.aws.ecs.model.OSFamily]
    def getCpuArchitecture
        : ZIO[Any, AwsError, zio.aws.ecs.model.CPUArchitecture] =
      AwsError.unwrapOptionField("cpuArchitecture", cpuArchitecture)
    def getOperatingSystemFamily
        : ZIO[Any, AwsError, zio.aws.ecs.model.OSFamily] =
      AwsError.unwrapOptionField("operatingSystemFamily", operatingSystemFamily)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.RuntimePlatform
  ) extends zio.aws.ecs.model.RuntimePlatform.ReadOnly {
    override val cpuArchitecture: Option[zio.aws.ecs.model.CPUArchitecture] =
      scala
        .Option(impl.cpuArchitecture())
        .map(value => zio.aws.ecs.model.CPUArchitecture.wrap(value))
    override val operatingSystemFamily: Option[zio.aws.ecs.model.OSFamily] =
      scala
        .Option(impl.operatingSystemFamily())
        .map(value => zio.aws.ecs.model.OSFamily.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.RuntimePlatform
  ): zio.aws.ecs.model.RuntimePlatform.ReadOnly = new Wrapper(impl)
}
