package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutAttributesRequest(
    cluster: Option[String] = None,
    attributes: Iterable[zio.aws.ecs.model.Attribute]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.PutAttributesRequest = {
    import PutAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.PutAttributesRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .attributes(attributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.PutAttributesRequest.ReadOnly =
    zio.aws.ecs.model.PutAttributesRequest.wrap(buildAwsValue())
}
object PutAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.PutAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.PutAttributesRequest =
      zio.aws.ecs.model.PutAttributesRequest(
        cluster.map(value => value),
        attributes.map { item =>
          item.asEditable
        }
      )
    def cluster: Option[String]
    def attributes: List[zio.aws.ecs.model.Attribute.ReadOnly]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getAttributes
        : ZIO[Any, Nothing, List[zio.aws.ecs.model.Attribute.ReadOnly]] =
      ZIO.succeed(attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.PutAttributesRequest
  ) extends zio.aws.ecs.model.PutAttributesRequest.ReadOnly {
    override val cluster: Option[String] =
      scala.Option(impl.cluster()).map(value => value: String)
    override val attributes: List[zio.aws.ecs.model.Attribute.ReadOnly] = impl
      .attributes()
      .asScala
      .map { item =>
        zio.aws.ecs.model.Attribute.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.PutAttributesRequest
  ): zio.aws.ecs.model.PutAttributesRequest.ReadOnly = new Wrapper(impl)
}
