package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait NetworkMode {
  def unwrap: software.amazon.awssdk.services.ecs.model.NetworkMode
}
object NetworkMode {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.NetworkMode
  ): zio.aws.ecs.model.NetworkMode = value match {
    case software.amazon.awssdk.services.ecs.model.NetworkMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.NetworkMode.BRIDGE =>
      val r = bridge
      r
    case software.amazon.awssdk.services.ecs.model.NetworkMode.HOST =>
      val r = host
      r
    case software.amazon.awssdk.services.ecs.model.NetworkMode.AWSVPC =>
      val r = awsvpc
      r
    case software.amazon.awssdk.services.ecs.model.NetworkMode.NONE =>
      val r = none
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.NetworkMode {
    override def unwrap: software.amazon.awssdk.services.ecs.model.NetworkMode =
      software.amazon.awssdk.services.ecs.model.NetworkMode.UNKNOWN_TO_SDK_VERSION
  }
  case object bridge extends zio.aws.ecs.model.NetworkMode {
    override def unwrap: software.amazon.awssdk.services.ecs.model.NetworkMode =
      software.amazon.awssdk.services.ecs.model.NetworkMode.BRIDGE
  }
  case object host extends zio.aws.ecs.model.NetworkMode {
    override def unwrap: software.amazon.awssdk.services.ecs.model.NetworkMode =
      software.amazon.awssdk.services.ecs.model.NetworkMode.HOST
  }
  case object awsvpc extends zio.aws.ecs.model.NetworkMode {
    override def unwrap: software.amazon.awssdk.services.ecs.model.NetworkMode =
      software.amazon.awssdk.services.ecs.model.NetworkMode.AWSVPC
  }
  case object none extends zio.aws.ecs.model.NetworkMode {
    override def unwrap: software.amazon.awssdk.services.ecs.model.NetworkMode =
      software.amazon.awssdk.services.ecs.model.NetworkMode.NONE
  }
}
