package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeploymentConfiguration(
    deploymentCircuitBreaker: Option[
      zio.aws.ecs.model.DeploymentCircuitBreaker
    ] = None,
    maximumPercent: Option[BoxedInteger] = None,
    minimumHealthyPercent: Option[BoxedInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DeploymentConfiguration = {
    import DeploymentConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DeploymentConfiguration
      .builder()
      .optionallyWith(
        deploymentCircuitBreaker.map(value => value.buildAwsValue())
      )(_.deploymentCircuitBreaker)
      .optionallyWith(maximumPercent.map(value => value: Integer))(
        _.maximumPercent
      )
      .optionallyWith(minimumHealthyPercent.map(value => value: Integer))(
        _.minimumHealthyPercent
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DeploymentConfiguration.ReadOnly =
    zio.aws.ecs.model.DeploymentConfiguration.wrap(buildAwsValue())
}
object DeploymentConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DeploymentConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DeploymentConfiguration =
      zio.aws.ecs.model.DeploymentConfiguration(
        deploymentCircuitBreaker.map(value => value.asEditable),
        maximumPercent.map(value => value),
        minimumHealthyPercent.map(value => value)
      )
    def deploymentCircuitBreaker
        : Option[zio.aws.ecs.model.DeploymentCircuitBreaker.ReadOnly]
    def maximumPercent: Option[BoxedInteger]
    def minimumHealthyPercent: Option[BoxedInteger]
    def getDeploymentCircuitBreaker: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.DeploymentCircuitBreaker.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deploymentCircuitBreaker",
      deploymentCircuitBreaker
    )
    def getMaximumPercent: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maximumPercent", maximumPercent)
    def getMinimumHealthyPercent: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("minimumHealthyPercent", minimumHealthyPercent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DeploymentConfiguration
  ) extends zio.aws.ecs.model.DeploymentConfiguration.ReadOnly {
    override val deploymentCircuitBreaker
        : Option[zio.aws.ecs.model.DeploymentCircuitBreaker.ReadOnly] = scala
      .Option(impl.deploymentCircuitBreaker())
      .map(value => zio.aws.ecs.model.DeploymentCircuitBreaker.wrap(value))
    override val maximumPercent: Option[BoxedInteger] =
      scala.Option(impl.maximumPercent()).map(value => value: BoxedInteger)
    override val minimumHealthyPercent: Option[BoxedInteger] = scala
      .Option(impl.minimumHealthyPercent())
      .map(value => value: BoxedInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DeploymentConfiguration
  ): zio.aws.ecs.model.DeploymentConfiguration.ReadOnly = new Wrapper(impl)
}
