package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.{Timestamp, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Deployment(
    id: Option[String] = None,
    status: Option[String] = None,
    taskDefinition: Option[String] = None,
    desiredCount: Option[Integer] = None,
    pendingCount: Option[Integer] = None,
    runningCount: Option[Integer] = None,
    failedTasks: Option[Integer] = None,
    createdAt: Option[Timestamp] = None,
    updatedAt: Option[Timestamp] = None,
    capacityProviderStrategy: Option[
      Iterable[zio.aws.ecs.model.CapacityProviderStrategyItem]
    ] = None,
    launchType: Option[zio.aws.ecs.model.LaunchType] = None,
    platformVersion: Option[String] = None,
    platformFamily: Option[String] = None,
    networkConfiguration: Option[zio.aws.ecs.model.NetworkConfiguration] = None,
    rolloutState: Option[zio.aws.ecs.model.DeploymentRolloutState] = None,
    rolloutStateReason: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Deployment = {
    import Deployment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Deployment
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(taskDefinition.map(value => value: java.lang.String))(
        _.taskDefinition
      )
      .optionallyWith(desiredCount.map(value => value: java.lang.Integer))(
        _.desiredCount
      )
      .optionallyWith(pendingCount.map(value => value: java.lang.Integer))(
        _.pendingCount
      )
      .optionallyWith(runningCount.map(value => value: java.lang.Integer))(
        _.runningCount
      )
      .optionallyWith(failedTasks.map(value => value: java.lang.Integer))(
        _.failedTasks
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviderStrategy)
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(platformFamily.map(value => value: java.lang.String))(
        _.platformFamily
      )
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(rolloutState.map(value => value.unwrap))(_.rolloutState)
      .optionallyWith(rolloutStateReason.map(value => value: java.lang.String))(
        _.rolloutStateReason
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Deployment.ReadOnly =
    zio.aws.ecs.model.Deployment.wrap(buildAwsValue())
}
object Deployment {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Deployment] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Deployment = zio.aws.ecs.model.Deployment(
      id.map(value => value),
      status.map(value => value),
      taskDefinition.map(value => value),
      desiredCount.map(value => value),
      pendingCount.map(value => value),
      runningCount.map(value => value),
      failedTasks.map(value => value),
      createdAt.map(value => value),
      updatedAt.map(value => value),
      capacityProviderStrategy.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      launchType.map(value => value),
      platformVersion.map(value => value),
      platformFamily.map(value => value),
      networkConfiguration.map(value => value.asEditable),
      rolloutState.map(value => value),
      rolloutStateReason.map(value => value)
    )
    def id: Option[String]
    def status: Option[String]
    def taskDefinition: Option[String]
    def desiredCount: Option[Integer]
    def pendingCount: Option[Integer]
    def runningCount: Option[Integer]
    def failedTasks: Option[Integer]
    def createdAt: Option[Timestamp]
    def updatedAt: Option[Timestamp]
    def capacityProviderStrategy
        : Option[List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]]
    def launchType: Option[zio.aws.ecs.model.LaunchType]
    def platformVersion: Option[String]
    def platformFamily: Option[String]
    def networkConfiguration
        : Option[zio.aws.ecs.model.NetworkConfiguration.ReadOnly]
    def rolloutState: Option[zio.aws.ecs.model.DeploymentRolloutState]
    def rolloutStateReason: Option[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getTaskDefinition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskDefinition", taskDefinition)
    def getDesiredCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("desiredCount", desiredCount)
    def getPendingCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("pendingCount", pendingCount)
    def getRunningCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("runningCount", runningCount)
    def getFailedTasks: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("failedTasks", failedTasks)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityProviderStrategy",
      capacityProviderStrategy
    )
    def getLaunchType: ZIO[Any, AwsError, zio.aws.ecs.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getPlatformFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformFamily", platformFamily)
    def getNetworkConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getRolloutState
        : ZIO[Any, AwsError, zio.aws.ecs.model.DeploymentRolloutState] =
      AwsError.unwrapOptionField("rolloutState", rolloutState)
    def getRolloutStateReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rolloutStateReason", rolloutStateReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Deployment
  ) extends zio.aws.ecs.model.Deployment.ReadOnly {
    override val id: Option[String] =
      scala.Option(impl.id()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val taskDefinition: Option[String] =
      scala.Option(impl.taskDefinition()).map(value => value: String)
    override val desiredCount: Option[Integer] =
      scala.Option(impl.desiredCount()).map(value => value: Integer)
    override val pendingCount: Option[Integer] =
      scala.Option(impl.pendingCount()).map(value => value: Integer)
    override val runningCount: Option[Integer] =
      scala.Option(impl.runningCount()).map(value => value: Integer)
    override val failedTasks: Option[Integer] =
      scala.Option(impl.failedTasks()).map(value => value: Integer)
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val capacityProviderStrategy: Option[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ] = scala
      .Option(impl.capacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
    override val launchType: Option[zio.aws.ecs.model.LaunchType] = scala
      .Option(impl.launchType())
      .map(value => zio.aws.ecs.model.LaunchType.wrap(value))
    override val platformVersion: Option[String] =
      scala.Option(impl.platformVersion()).map(value => value: String)
    override val platformFamily: Option[String] =
      scala.Option(impl.platformFamily()).map(value => value: String)
    override val networkConfiguration
        : Option[zio.aws.ecs.model.NetworkConfiguration.ReadOnly] = scala
      .Option(impl.networkConfiguration())
      .map(value => zio.aws.ecs.model.NetworkConfiguration.wrap(value))
    override val rolloutState
        : Option[zio.aws.ecs.model.DeploymentRolloutState] = scala
      .Option(impl.rolloutState())
      .map(value => zio.aws.ecs.model.DeploymentRolloutState.wrap(value))
    override val rolloutStateReason: Option[String] =
      scala.Option(impl.rolloutStateReason()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Deployment
  ): zio.aws.ecs.model.Deployment.ReadOnly = new Wrapper(impl)
}
