package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateServiceRequest(
    cluster: Option[String] = None,
    serviceName: String,
    taskDefinition: Option[String] = None,
    loadBalancers: Option[Iterable[zio.aws.ecs.model.LoadBalancer]] = None,
    serviceRegistries: Option[Iterable[zio.aws.ecs.model.ServiceRegistry]] =
      None,
    desiredCount: Option[BoxedInteger] = None,
    clientToken: Option[String] = None,
    launchType: Option[zio.aws.ecs.model.LaunchType] = None,
    capacityProviderStrategy: Option[
      Iterable[zio.aws.ecs.model.CapacityProviderStrategyItem]
    ] = None,
    platformVersion: Option[String] = None,
    role: Option[String] = None,
    deploymentConfiguration: Option[zio.aws.ecs.model.DeploymentConfiguration] =
      None,
    placementConstraints: Option[
      Iterable[zio.aws.ecs.model.PlacementConstraint]
    ] = None,
    placementStrategy: Option[Iterable[zio.aws.ecs.model.PlacementStrategy]] =
      None,
    networkConfiguration: Option[zio.aws.ecs.model.NetworkConfiguration] = None,
    healthCheckGracePeriodSeconds: Option[BoxedInteger] = None,
    schedulingStrategy: Option[zio.aws.ecs.model.SchedulingStrategy] = None,
    deploymentController: Option[zio.aws.ecs.model.DeploymentController] = None,
    tags: Option[Iterable[zio.aws.ecs.model.Tag]] = None,
    enableECSManagedTags: Option[Boolean] = None,
    propagateTags: Option[zio.aws.ecs.model.PropagateTags] = None,
    enableExecuteCommand: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.CreateServiceRequest = {
    import CreateServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.CreateServiceRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .serviceName(serviceName: java.lang.String)
      .optionallyWith(taskDefinition.map(value => value: java.lang.String))(
        _.taskDefinition
      )
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .optionallyWith(
        serviceRegistries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceRegistries)
      .optionallyWith(desiredCount.map(value => value: Integer))(_.desiredCount)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .optionallyWith(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviderStrategy)
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(role.map(value => value: java.lang.String))(_.role)
      .optionallyWith(
        deploymentConfiguration.map(value => value.buildAwsValue())
      )(_.deploymentConfiguration)
      .optionallyWith(
        placementConstraints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementConstraints)
      .optionallyWith(
        placementStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementStrategy)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(
        healthCheckGracePeriodSeconds.map(value => value: Integer)
      )(_.healthCheckGracePeriodSeconds)
      .optionallyWith(schedulingStrategy.map(value => value.unwrap))(
        _.schedulingStrategy
      )
      .optionallyWith(deploymentController.map(value => value.buildAwsValue()))(
        _.deploymentController
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        enableECSManagedTags.map(value => value: java.lang.Boolean)
      )(_.enableECSManagedTags)
      .optionallyWith(propagateTags.map(value => value.unwrap))(_.propagateTags)
      .optionallyWith(
        enableExecuteCommand.map(value => value: java.lang.Boolean)
      )(_.enableExecuteCommand)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.CreateServiceRequest.ReadOnly =
    zio.aws.ecs.model.CreateServiceRequest.wrap(buildAwsValue())
}
object CreateServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.CreateServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.CreateServiceRequest =
      zio.aws.ecs.model.CreateServiceRequest(
        cluster.map(value => value),
        serviceName,
        taskDefinition.map(value => value),
        loadBalancers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serviceRegistries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        desiredCount.map(value => value),
        clientToken.map(value => value),
        launchType.map(value => value),
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platformVersion.map(value => value),
        role.map(value => value),
        deploymentConfiguration.map(value => value.asEditable),
        placementConstraints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placementStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkConfiguration.map(value => value.asEditable),
        healthCheckGracePeriodSeconds.map(value => value),
        schedulingStrategy.map(value => value),
        deploymentController.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enableECSManagedTags.map(value => value),
        propagateTags.map(value => value),
        enableExecuteCommand.map(value => value)
      )
    def cluster: Option[String]
    def serviceName: String
    def taskDefinition: Option[String]
    def loadBalancers: Option[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]]
    def serviceRegistries
        : Option[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]]
    def desiredCount: Option[BoxedInteger]
    def clientToken: Option[String]
    def launchType: Option[zio.aws.ecs.model.LaunchType]
    def capacityProviderStrategy
        : Option[List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]]
    def platformVersion: Option[String]
    def role: Option[String]
    def deploymentConfiguration
        : Option[zio.aws.ecs.model.DeploymentConfiguration.ReadOnly]
    def placementConstraints
        : Option[List[zio.aws.ecs.model.PlacementConstraint.ReadOnly]]
    def placementStrategy
        : Option[List[zio.aws.ecs.model.PlacementStrategy.ReadOnly]]
    def networkConfiguration
        : Option[zio.aws.ecs.model.NetworkConfiguration.ReadOnly]
    def healthCheckGracePeriodSeconds: Option[BoxedInteger]
    def schedulingStrategy: Option[zio.aws.ecs.model.SchedulingStrategy]
    def deploymentController
        : Option[zio.aws.ecs.model.DeploymentController.ReadOnly]
    def tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def enableECSManagedTags: Option[Boolean]
    def propagateTags: Option[zio.aws.ecs.model.PropagateTags]
    def enableExecuteCommand: Option[Boolean]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getServiceName: ZIO[Any, Nothing, String] = ZIO.succeed(serviceName)
    def getTaskDefinition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskDefinition", taskDefinition)
    def getLoadBalancers
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] =
      AwsError.unwrapOptionField("loadBalancers", loadBalancers)
    def getServiceRegistries
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] =
      AwsError.unwrapOptionField("serviceRegistries", serviceRegistries)
    def getDesiredCount: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("desiredCount", desiredCount)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getLaunchType: ZIO[Any, AwsError, zio.aws.ecs.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityProviderStrategy",
      capacityProviderStrategy
    )
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("role", role)
    def getDeploymentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.DeploymentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deploymentConfiguration",
      deploymentConfiguration
    )
    def getPlacementConstraints: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.PlacementConstraint.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placementConstraints", placementConstraints)
    def getPlacementStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.PlacementStrategy.ReadOnly
    ]] = AwsError.unwrapOptionField("placementStrategy", placementStrategy)
    def getNetworkConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getHealthCheckGracePeriodSeconds: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField(
        "healthCheckGracePeriodSeconds",
        healthCheckGracePeriodSeconds
      )
    def getSchedulingStrategy
        : ZIO[Any, AwsError, zio.aws.ecs.model.SchedulingStrategy] =
      AwsError.unwrapOptionField("schedulingStrategy", schedulingStrategy)
    def getDeploymentController
        : ZIO[Any, AwsError, zio.aws.ecs.model.DeploymentController.ReadOnly] =
      AwsError.unwrapOptionField("deploymentController", deploymentController)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEnableECSManagedTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableECSManagedTags", enableECSManagedTags)
    def getPropagateTags: ZIO[Any, AwsError, zio.aws.ecs.model.PropagateTags] =
      AwsError.unwrapOptionField("propagateTags", propagateTags)
    def getEnableExecuteCommand: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableExecuteCommand", enableExecuteCommand)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.CreateServiceRequest
  ) extends zio.aws.ecs.model.CreateServiceRequest.ReadOnly {
    override val cluster: Option[String] =
      scala.Option(impl.cluster()).map(value => value: String)
    override val serviceName: String = impl.serviceName(): String
    override val taskDefinition: Option[String] =
      scala.Option(impl.taskDefinition()).map(value => value: String)
    override val loadBalancers
        : Option[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] = scala
      .Option(impl.loadBalancers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.LoadBalancer.wrap(item)
        }.toList
      )
    override val serviceRegistries
        : Option[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] = scala
      .Option(impl.serviceRegistries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ServiceRegistry.wrap(item)
        }.toList
      )
    override val desiredCount: Option[BoxedInteger] =
      scala.Option(impl.desiredCount()).map(value => value: BoxedInteger)
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val launchType: Option[zio.aws.ecs.model.LaunchType] = scala
      .Option(impl.launchType())
      .map(value => zio.aws.ecs.model.LaunchType.wrap(value))
    override val capacityProviderStrategy: Option[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ] = scala
      .Option(impl.capacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
    override val platformVersion: Option[String] =
      scala.Option(impl.platformVersion()).map(value => value: String)
    override val role: Option[String] =
      scala.Option(impl.role()).map(value => value: String)
    override val deploymentConfiguration
        : Option[zio.aws.ecs.model.DeploymentConfiguration.ReadOnly] = scala
      .Option(impl.deploymentConfiguration())
      .map(value => zio.aws.ecs.model.DeploymentConfiguration.wrap(value))
    override val placementConstraints
        : Option[List[zio.aws.ecs.model.PlacementConstraint.ReadOnly]] = scala
      .Option(impl.placementConstraints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.PlacementConstraint.wrap(item)
        }.toList
      )
    override val placementStrategy
        : Option[List[zio.aws.ecs.model.PlacementStrategy.ReadOnly]] = scala
      .Option(impl.placementStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.PlacementStrategy.wrap(item)
        }.toList
      )
    override val networkConfiguration
        : Option[zio.aws.ecs.model.NetworkConfiguration.ReadOnly] = scala
      .Option(impl.networkConfiguration())
      .map(value => zio.aws.ecs.model.NetworkConfiguration.wrap(value))
    override val healthCheckGracePeriodSeconds: Option[BoxedInteger] = scala
      .Option(impl.healthCheckGracePeriodSeconds())
      .map(value => value: BoxedInteger)
    override val schedulingStrategy
        : Option[zio.aws.ecs.model.SchedulingStrategy] = scala
      .Option(impl.schedulingStrategy())
      .map(value => zio.aws.ecs.model.SchedulingStrategy.wrap(value))
    override val deploymentController
        : Option[zio.aws.ecs.model.DeploymentController.ReadOnly] = scala
      .Option(impl.deploymentController())
      .map(value => zio.aws.ecs.model.DeploymentController.wrap(value))
    override val tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Tag.wrap(item)
        }.toList
      )
    override val enableECSManagedTags: Option[Boolean] =
      scala.Option(impl.enableECSManagedTags()).map(value => value: Boolean)
    override val propagateTags: Option[zio.aws.ecs.model.PropagateTags] = scala
      .Option(impl.propagateTags())
      .map(value => zio.aws.ecs.model.PropagateTags.wrap(value))
    override val enableExecuteCommand: Option[Boolean] =
      scala.Option(impl.enableExecuteCommand()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.CreateServiceRequest
  ): zio.aws.ecs.model.CreateServiceRequest.ReadOnly = new Wrapper(impl)
}
