package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SubmitContainerStateChangeRequest(
    cluster: Option[String] = None,
    task: Option[String] = None,
    containerName: Option[String] = None,
    runtimeId: Option[String] = None,
    status: Option[String] = None,
    exitCode: Option[BoxedInteger] = None,
    reason: Option[String] = None,
    networkBindings: Option[Iterable[zio.aws.ecs.model.NetworkBinding]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeRequest = {
    import SubmitContainerStateChangeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .optionallyWith(task.map(value => value: java.lang.String))(_.task)
      .optionallyWith(containerName.map(value => value: java.lang.String))(
        _.containerName
      )
      .optionallyWith(runtimeId.map(value => value: java.lang.String))(
        _.runtimeId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(exitCode.map(value => value: Integer))(_.exitCode)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .optionallyWith(
        networkBindings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkBindings)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.SubmitContainerStateChangeRequest.ReadOnly =
    zio.aws.ecs.model.SubmitContainerStateChangeRequest.wrap(buildAwsValue())
}
object SubmitContainerStateChangeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.SubmitContainerStateChangeRequest =
      zio.aws.ecs.model.SubmitContainerStateChangeRequest(
        cluster.map(value => value),
        task.map(value => value),
        containerName.map(value => value),
        runtimeId.map(value => value),
        status.map(value => value),
        exitCode.map(value => value),
        reason.map(value => value),
        networkBindings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cluster: Option[String]
    def task: Option[String]
    def containerName: Option[String]
    def runtimeId: Option[String]
    def status: Option[String]
    def exitCode: Option[BoxedInteger]
    def reason: Option[String]
    def networkBindings: Option[List[zio.aws.ecs.model.NetworkBinding.ReadOnly]]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getTask: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("task", task)
    def getContainerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerName", containerName)
    def getRuntimeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("runtimeId", runtimeId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getExitCode: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("exitCode", exitCode)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
    def getNetworkBindings
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.NetworkBinding.ReadOnly]] =
      AwsError.unwrapOptionField("networkBindings", networkBindings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeRequest
  ) extends zio.aws.ecs.model.SubmitContainerStateChangeRequest.ReadOnly {
    override val cluster: Option[String] =
      scala.Option(impl.cluster()).map(value => value: String)
    override val task: Option[String] =
      scala.Option(impl.task()).map(value => value: String)
    override val containerName: Option[String] =
      scala.Option(impl.containerName()).map(value => value: String)
    override val runtimeId: Option[String] =
      scala.Option(impl.runtimeId()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val exitCode: Option[BoxedInteger] =
      scala.Option(impl.exitCode()).map(value => value: BoxedInteger)
    override val reason: Option[String] =
      scala.Option(impl.reason()).map(value => value: String)
    override val networkBindings
        : Option[List[zio.aws.ecs.model.NetworkBinding.ReadOnly]] = scala
      .Option(impl.networkBindings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.NetworkBinding.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeRequest
  ): zio.aws.ecs.model.SubmitContainerStateChangeRequest.ReadOnly = new Wrapper(
    impl
  )
}
