package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeContainerInstancesResponse(
    containerInstances: Option[Iterable[zio.aws.ecs.model.ContainerInstance]] =
      None,
    failures: Option[Iterable[zio.aws.ecs.model.Failure]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DescribeContainerInstancesResponse = {
    import DescribeContainerInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DescribeContainerInstancesResponse
      .builder()
      .optionallyWith(
        containerInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containerInstances)
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly
      : zio.aws.ecs.model.DescribeContainerInstancesResponse.ReadOnly =
    zio.aws.ecs.model.DescribeContainerInstancesResponse.wrap(buildAwsValue())
}
object DescribeContainerInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DescribeContainerInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DescribeContainerInstancesResponse =
      zio.aws.ecs.model.DescribeContainerInstancesResponse(
        containerInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def containerInstances
        : Option[List[zio.aws.ecs.model.ContainerInstance.ReadOnly]]
    def failures: Option[List[zio.aws.ecs.model.Failure.ReadOnly]]
    def getContainerInstances: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.ContainerInstance.ReadOnly
    ]] = AwsError.unwrapOptionField("containerInstances", containerInstances)
    def getFailures
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Failure.ReadOnly]] =
      AwsError.unwrapOptionField("failures", failures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DescribeContainerInstancesResponse
  ) extends zio.aws.ecs.model.DescribeContainerInstancesResponse.ReadOnly {
    override val containerInstances
        : Option[List[zio.aws.ecs.model.ContainerInstance.ReadOnly]] = scala
      .Option(impl.containerInstances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ContainerInstance.wrap(item)
        }.toList
      )
    override val failures: Option[List[zio.aws.ecs.model.Failure.ReadOnly]] =
      scala
        .Option(impl.failures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Failure.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DescribeContainerInstancesResponse
  ): zio.aws.ecs.model.DescribeContainerInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
