package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeCapacityProvidersResponse(
    capacityProviders: Option[Iterable[zio.aws.ecs.model.CapacityProvider]] =
      None,
    failures: Option[Iterable[zio.aws.ecs.model.Failure]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersResponse = {
    import DescribeCapacityProvidersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersResponse
      .builder()
      .optionallyWith(
        capacityProviders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviders)
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DescribeCapacityProvidersResponse.ReadOnly =
    zio.aws.ecs.model.DescribeCapacityProvidersResponse.wrap(buildAwsValue())
}
object DescribeCapacityProvidersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DescribeCapacityProvidersResponse =
      zio.aws.ecs.model.DescribeCapacityProvidersResponse(
        capacityProviders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def capacityProviders
        : Option[List[zio.aws.ecs.model.CapacityProvider.ReadOnly]]
    def failures: Option[List[zio.aws.ecs.model.Failure.ReadOnly]]
    def nextToken: Option[String]
    def getCapacityProviders: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProvider.ReadOnly
    ]] = AwsError.unwrapOptionField("capacityProviders", capacityProviders)
    def getFailures
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Failure.ReadOnly]] =
      AwsError.unwrapOptionField("failures", failures)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersResponse
  ) extends zio.aws.ecs.model.DescribeCapacityProvidersResponse.ReadOnly {
    override val capacityProviders
        : Option[List[zio.aws.ecs.model.CapacityProvider.ReadOnly]] = scala
      .Option(impl.capacityProviders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.CapacityProvider.wrap(item)
        }.toList
      )
    override val failures: Option[List[zio.aws.ecs.model.Failure.ReadOnly]] =
      scala
        .Option(impl.failures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Failure.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersResponse
  ): zio.aws.ecs.model.DescribeCapacityProvidersResponse.ReadOnly = new Wrapper(
    impl
  )
}
