package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteCapacityProviderResponse(
    capacityProvider: Option[zio.aws.ecs.model.CapacityProvider] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DeleteCapacityProviderResponse = {
    import DeleteCapacityProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DeleteCapacityProviderResponse
      .builder()
      .optionallyWith(capacityProvider.map(value => value.buildAwsValue()))(
        _.capacityProvider
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DeleteCapacityProviderResponse.ReadOnly =
    zio.aws.ecs.model.DeleteCapacityProviderResponse.wrap(buildAwsValue())
}
object DeleteCapacityProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DeleteCapacityProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DeleteCapacityProviderResponse =
      zio.aws.ecs.model.DeleteCapacityProviderResponse(
        capacityProvider.map(value => value.asEditable)
      )
    def capacityProvider: Option[zio.aws.ecs.model.CapacityProvider.ReadOnly]
    def getCapacityProvider
        : ZIO[Any, AwsError, zio.aws.ecs.model.CapacityProvider.ReadOnly] =
      AwsError.unwrapOptionField("capacityProvider", capacityProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DeleteCapacityProviderResponse
  ) extends zio.aws.ecs.model.DeleteCapacityProviderResponse.ReadOnly {
    override val capacityProvider
        : Option[zio.aws.ecs.model.CapacityProvider.ReadOnly] = scala
      .Option(impl.capacityProvider())
      .map(value => zio.aws.ecs.model.CapacityProvider.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DeleteCapacityProviderResponse
  ): zio.aws.ecs.model.DeleteCapacityProviderResponse.ReadOnly = new Wrapper(
    impl
  )
}
