package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ContainerStateChange(
    containerName: Option[String] = None,
    imageDigest: Option[String] = None,
    runtimeId: Option[String] = None,
    exitCode: Option[BoxedInteger] = None,
    networkBindings: Option[Iterable[zio.aws.ecs.model.NetworkBinding]] = None,
    reason: Option[String] = None,
    status: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ContainerStateChange = {
    import ContainerStateChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ContainerStateChange
      .builder()
      .optionallyWith(containerName.map(value => value: java.lang.String))(
        _.containerName
      )
      .optionallyWith(imageDigest.map(value => value: java.lang.String))(
        _.imageDigest
      )
      .optionallyWith(runtimeId.map(value => value: java.lang.String))(
        _.runtimeId
      )
      .optionallyWith(exitCode.map(value => value: Integer))(_.exitCode)
      .optionallyWith(
        networkBindings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkBindings)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ContainerStateChange.ReadOnly =
    zio.aws.ecs.model.ContainerStateChange.wrap(buildAwsValue())
}
object ContainerStateChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ContainerStateChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ContainerStateChange =
      zio.aws.ecs.model.ContainerStateChange(
        containerName.map(value => value),
        imageDigest.map(value => value),
        runtimeId.map(value => value),
        exitCode.map(value => value),
        networkBindings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reason.map(value => value),
        status.map(value => value)
      )
    def containerName: Option[String]
    def imageDigest: Option[String]
    def runtimeId: Option[String]
    def exitCode: Option[BoxedInteger]
    def networkBindings: Option[List[zio.aws.ecs.model.NetworkBinding.ReadOnly]]
    def reason: Option[String]
    def status: Option[String]
    def getContainerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerName", containerName)
    def getImageDigest: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageDigest", imageDigest)
    def getRuntimeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("runtimeId", runtimeId)
    def getExitCode: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("exitCode", exitCode)
    def getNetworkBindings
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.NetworkBinding.ReadOnly]] =
      AwsError.unwrapOptionField("networkBindings", networkBindings)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ContainerStateChange
  ) extends zio.aws.ecs.model.ContainerStateChange.ReadOnly {
    override val containerName: Option[String] =
      scala.Option(impl.containerName()).map(value => value: String)
    override val imageDigest: Option[String] =
      scala.Option(impl.imageDigest()).map(value => value: String)
    override val runtimeId: Option[String] =
      scala.Option(impl.runtimeId()).map(value => value: String)
    override val exitCode: Option[BoxedInteger] =
      scala.Option(impl.exitCode()).map(value => value: BoxedInteger)
    override val networkBindings
        : Option[List[zio.aws.ecs.model.NetworkBinding.ReadOnly]] = scala
      .Option(impl.networkBindings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.NetworkBinding.wrap(item)
        }.toList
      )
    override val reason: Option[String] =
      scala.Option(impl.reason()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ContainerStateChange
  ): zio.aws.ecs.model.ContainerStateChange.ReadOnly = new Wrapper(impl)
}
