package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.{BoxedBoolean, BoxedInteger, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ContainerDefinition(
    name: Option[String] = None,
    image: Option[String] = None,
    repositoryCredentials: Option[zio.aws.ecs.model.RepositoryCredentials] =
      None,
    cpu: Option[Integer] = None,
    memory: Option[BoxedInteger] = None,
    memoryReservation: Option[BoxedInteger] = None,
    links: Option[Iterable[String]] = None,
    portMappings: Option[Iterable[zio.aws.ecs.model.PortMapping]] = None,
    essential: Option[BoxedBoolean] = None,
    entryPoint: Option[Iterable[String]] = None,
    command: Option[Iterable[String]] = None,
    environment: Option[Iterable[zio.aws.ecs.model.KeyValuePair]] = None,
    environmentFiles: Option[Iterable[zio.aws.ecs.model.EnvironmentFile]] =
      None,
    mountPoints: Option[Iterable[zio.aws.ecs.model.MountPoint]] = None,
    volumesFrom: Option[Iterable[zio.aws.ecs.model.VolumeFrom]] = None,
    linuxParameters: Option[zio.aws.ecs.model.LinuxParameters] = None,
    secrets: Option[Iterable[zio.aws.ecs.model.Secret]] = None,
    dependsOn: Option[Iterable[zio.aws.ecs.model.ContainerDependency]] = None,
    startTimeout: Option[BoxedInteger] = None,
    stopTimeout: Option[BoxedInteger] = None,
    hostname: Option[String] = None,
    user: Option[String] = None,
    workingDirectory: Option[String] = None,
    disableNetworking: Option[BoxedBoolean] = None,
    privileged: Option[BoxedBoolean] = None,
    readonlyRootFilesystem: Option[BoxedBoolean] = None,
    dnsServers: Option[Iterable[String]] = None,
    dnsSearchDomains: Option[Iterable[String]] = None,
    extraHosts: Option[Iterable[zio.aws.ecs.model.HostEntry]] = None,
    dockerSecurityOptions: Option[Iterable[String]] = None,
    interactive: Option[BoxedBoolean] = None,
    pseudoTerminal: Option[BoxedBoolean] = None,
    dockerLabels: Option[Map[String, String]] = None,
    ulimits: Option[Iterable[zio.aws.ecs.model.Ulimit]] = None,
    logConfiguration: Option[zio.aws.ecs.model.LogConfiguration] = None,
    healthCheck: Option[zio.aws.ecs.model.HealthCheck] = None,
    systemControls: Option[Iterable[zio.aws.ecs.model.SystemControl]] = None,
    resourceRequirements: Option[
      Iterable[zio.aws.ecs.model.ResourceRequirement]
    ] = None,
    firelensConfiguration: Option[zio.aws.ecs.model.FirelensConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ContainerDefinition = {
    import ContainerDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ContainerDefinition
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(image.map(value => value: java.lang.String))(_.image)
      .optionallyWith(
        repositoryCredentials.map(value => value.buildAwsValue())
      )(_.repositoryCredentials)
      .optionallyWith(cpu.map(value => value: java.lang.Integer))(_.cpu)
      .optionallyWith(memory.map(value => value: java.lang.Integer))(_.memory)
      .optionallyWith(memoryReservation.map(value => value: java.lang.Integer))(
        _.memoryReservation
      )
      .optionallyWith(
        links.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.links)
      .optionallyWith(
        portMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portMappings)
      .optionallyWith(essential.map(value => value: java.lang.Boolean))(
        _.essential
      )
      .optionallyWith(
        entryPoint.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.entryPoint)
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(
        environment.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environment)
      .optionallyWith(
        environmentFiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentFiles)
      .optionallyWith(
        mountPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mountPoints)
      .optionallyWith(
        volumesFrom.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumesFrom)
      .optionallyWith(linuxParameters.map(value => value.buildAwsValue()))(
        _.linuxParameters
      )
      .optionallyWith(
        secrets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secrets)
      .optionallyWith(
        dependsOn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dependsOn)
      .optionallyWith(startTimeout.map(value => value: java.lang.Integer))(
        _.startTimeout
      )
      .optionallyWith(stopTimeout.map(value => value: java.lang.Integer))(
        _.stopTimeout
      )
      .optionallyWith(hostname.map(value => value: java.lang.String))(
        _.hostname
      )
      .optionallyWith(user.map(value => value: java.lang.String))(_.user)
      .optionallyWith(workingDirectory.map(value => value: java.lang.String))(
        _.workingDirectory
      )
      .optionallyWith(disableNetworking.map(value => value: java.lang.Boolean))(
        _.disableNetworking
      )
      .optionallyWith(privileged.map(value => value: java.lang.Boolean))(
        _.privileged
      )
      .optionallyWith(
        readonlyRootFilesystem.map(value => value: java.lang.Boolean)
      )(_.readonlyRootFilesystem)
      .optionallyWith(
        dnsServers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dnsServers)
      .optionallyWith(
        dnsSearchDomains.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dnsSearchDomains)
      .optionallyWith(
        extraHosts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.extraHosts)
      .optionallyWith(
        dockerSecurityOptions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dockerSecurityOptions)
      .optionallyWith(interactive.map(value => value: java.lang.Boolean))(
        _.interactive
      )
      .optionallyWith(pseudoTerminal.map(value => value: java.lang.Boolean))(
        _.pseudoTerminal
      )
      .optionallyWith(
        dockerLabels.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.dockerLabels)
      .optionallyWith(
        ulimits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ulimits)
      .optionallyWith(logConfiguration.map(value => value.buildAwsValue()))(
        _.logConfiguration
      )
      .optionallyWith(healthCheck.map(value => value.buildAwsValue()))(
        _.healthCheck
      )
      .optionallyWith(
        systemControls.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.systemControls)
      .optionallyWith(
        resourceRequirements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceRequirements)
      .optionallyWith(
        firelensConfiguration.map(value => value.buildAwsValue())
      )(_.firelensConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ContainerDefinition.ReadOnly =
    zio.aws.ecs.model.ContainerDefinition.wrap(buildAwsValue())
}
object ContainerDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ContainerDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ContainerDefinition =
      zio.aws.ecs.model.ContainerDefinition(
        name.map(value => value),
        image.map(value => value),
        repositoryCredentials.map(value => value.asEditable),
        cpu.map(value => value),
        memory.map(value => value),
        memoryReservation.map(value => value),
        links.map(value => value),
        portMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        essential.map(value => value),
        entryPoint.map(value => value),
        command.map(value => value),
        environment.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        environmentFiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        mountPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        volumesFrom.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        linuxParameters.map(value => value.asEditable),
        secrets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dependsOn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        startTimeout.map(value => value),
        stopTimeout.map(value => value),
        hostname.map(value => value),
        user.map(value => value),
        workingDirectory.map(value => value),
        disableNetworking.map(value => value),
        privileged.map(value => value),
        readonlyRootFilesystem.map(value => value),
        dnsServers.map(value => value),
        dnsSearchDomains.map(value => value),
        extraHosts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dockerSecurityOptions.map(value => value),
        interactive.map(value => value),
        pseudoTerminal.map(value => value),
        dockerLabels.map(value => value),
        ulimits.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        logConfiguration.map(value => value.asEditable),
        healthCheck.map(value => value.asEditable),
        systemControls.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceRequirements.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        firelensConfiguration.map(value => value.asEditable)
      )
    def name: Option[String]
    def image: Option[String]
    def repositoryCredentials
        : Option[zio.aws.ecs.model.RepositoryCredentials.ReadOnly]
    def cpu: Option[Integer]
    def memory: Option[BoxedInteger]
    def memoryReservation: Option[BoxedInteger]
    def links: Option[List[String]]
    def portMappings: Option[List[zio.aws.ecs.model.PortMapping.ReadOnly]]
    def essential: Option[BoxedBoolean]
    def entryPoint: Option[List[String]]
    def command: Option[List[String]]
    def environment: Option[List[zio.aws.ecs.model.KeyValuePair.ReadOnly]]
    def environmentFiles
        : Option[List[zio.aws.ecs.model.EnvironmentFile.ReadOnly]]
    def mountPoints: Option[List[zio.aws.ecs.model.MountPoint.ReadOnly]]
    def volumesFrom: Option[List[zio.aws.ecs.model.VolumeFrom.ReadOnly]]
    def linuxParameters: Option[zio.aws.ecs.model.LinuxParameters.ReadOnly]
    def secrets: Option[List[zio.aws.ecs.model.Secret.ReadOnly]]
    def dependsOn: Option[List[zio.aws.ecs.model.ContainerDependency.ReadOnly]]
    def startTimeout: Option[BoxedInteger]
    def stopTimeout: Option[BoxedInteger]
    def hostname: Option[String]
    def user: Option[String]
    def workingDirectory: Option[String]
    def disableNetworking: Option[BoxedBoolean]
    def privileged: Option[BoxedBoolean]
    def readonlyRootFilesystem: Option[BoxedBoolean]
    def dnsServers: Option[List[String]]
    def dnsSearchDomains: Option[List[String]]
    def extraHosts: Option[List[zio.aws.ecs.model.HostEntry.ReadOnly]]
    def dockerSecurityOptions: Option[List[String]]
    def interactive: Option[BoxedBoolean]
    def pseudoTerminal: Option[BoxedBoolean]
    def dockerLabels: Option[Map[String, String]]
    def ulimits: Option[List[zio.aws.ecs.model.Ulimit.ReadOnly]]
    def logConfiguration: Option[zio.aws.ecs.model.LogConfiguration.ReadOnly]
    def healthCheck: Option[zio.aws.ecs.model.HealthCheck.ReadOnly]
    def systemControls: Option[List[zio.aws.ecs.model.SystemControl.ReadOnly]]
    def resourceRequirements
        : Option[List[zio.aws.ecs.model.ResourceRequirement.ReadOnly]]
    def firelensConfiguration
        : Option[zio.aws.ecs.model.FirelensConfiguration.ReadOnly]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getImage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("image", image)
    def getRepositoryCredentials
        : ZIO[Any, AwsError, zio.aws.ecs.model.RepositoryCredentials.ReadOnly] =
      AwsError.unwrapOptionField("repositoryCredentials", repositoryCredentials)
    def getCpu: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getMemory: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("memory", memory)
    def getMemoryReservation: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("memoryReservation", memoryReservation)
    def getLinks: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("links", links)
    def getPortMappings
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.PortMapping.ReadOnly]] =
      AwsError.unwrapOptionField("portMappings", portMappings)
    def getEssential: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("essential", essential)
    def getEntryPoint: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("entryPoint", entryPoint)
    def getCommand: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("command", command)
    def getEnvironment
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.KeyValuePair.ReadOnly]] =
      AwsError.unwrapOptionField("environment", environment)
    def getEnvironmentFiles
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.EnvironmentFile.ReadOnly]] =
      AwsError.unwrapOptionField("environmentFiles", environmentFiles)
    def getMountPoints
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.MountPoint.ReadOnly]] =
      AwsError.unwrapOptionField("mountPoints", mountPoints)
    def getVolumesFrom
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.VolumeFrom.ReadOnly]] =
      AwsError.unwrapOptionField("volumesFrom", volumesFrom)
    def getLinuxParameters
        : ZIO[Any, AwsError, zio.aws.ecs.model.LinuxParameters.ReadOnly] =
      AwsError.unwrapOptionField("linuxParameters", linuxParameters)
    def getSecrets
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Secret.ReadOnly]] =
      AwsError.unwrapOptionField("secrets", secrets)
    def getDependsOn: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.ContainerDependency.ReadOnly
    ]] = AwsError.unwrapOptionField("dependsOn", dependsOn)
    def getStartTimeout: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("startTimeout", startTimeout)
    def getStopTimeout: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("stopTimeout", stopTimeout)
    def getHostname: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostname", hostname)
    def getUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("user", user)
    def getWorkingDirectory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workingDirectory", workingDirectory)
    def getDisableNetworking: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("disableNetworking", disableNetworking)
    def getPrivileged: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("privileged", privileged)
    def getReadonlyRootFilesystem: ZIO[Any, AwsError, BoxedBoolean] = AwsError
      .unwrapOptionField("readonlyRootFilesystem", readonlyRootFilesystem)
    def getDnsServers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dnsServers", dnsServers)
    def getDnsSearchDomains: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dnsSearchDomains", dnsSearchDomains)
    def getExtraHosts
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.HostEntry.ReadOnly]] =
      AwsError.unwrapOptionField("extraHosts", extraHosts)
    def getDockerSecurityOptions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dockerSecurityOptions", dockerSecurityOptions)
    def getInteractive: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("interactive", interactive)
    def getPseudoTerminal: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("pseudoTerminal", pseudoTerminal)
    def getDockerLabels: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("dockerLabels", dockerLabels)
    def getUlimits
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Ulimit.ReadOnly]] =
      AwsError.unwrapOptionField("ulimits", ulimits)
    def getLogConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.LogConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("logConfiguration", logConfiguration)
    def getHealthCheck
        : ZIO[Any, AwsError, zio.aws.ecs.model.HealthCheck.ReadOnly] =
      AwsError.unwrapOptionField("healthCheck", healthCheck)
    def getSystemControls
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.SystemControl.ReadOnly]] =
      AwsError.unwrapOptionField("systemControls", systemControls)
    def getResourceRequirements: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.ResourceRequirement.ReadOnly
    ]] =
      AwsError.unwrapOptionField("resourceRequirements", resourceRequirements)
    def getFirelensConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.FirelensConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("firelensConfiguration", firelensConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ContainerDefinition
  ) extends zio.aws.ecs.model.ContainerDefinition.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val image: Option[String] =
      scala.Option(impl.image()).map(value => value: String)
    override val repositoryCredentials
        : Option[zio.aws.ecs.model.RepositoryCredentials.ReadOnly] = scala
      .Option(impl.repositoryCredentials())
      .map(value => zio.aws.ecs.model.RepositoryCredentials.wrap(value))
    override val cpu: Option[Integer] =
      scala.Option(impl.cpu()).map(value => value: Integer)
    override val memory: Option[BoxedInteger] =
      scala.Option(impl.memory()).map(value => value: BoxedInteger)
    override val memoryReservation: Option[BoxedInteger] =
      scala.Option(impl.memoryReservation()).map(value => value: BoxedInteger)
    override val links: Option[List[String]] = scala
      .Option(impl.links())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val portMappings
        : Option[List[zio.aws.ecs.model.PortMapping.ReadOnly]] = scala
      .Option(impl.portMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.PortMapping.wrap(item)
        }.toList
      )
    override val essential: Option[BoxedBoolean] =
      scala.Option(impl.essential()).map(value => value: BoxedBoolean)
    override val entryPoint: Option[List[String]] = scala
      .Option(impl.entryPoint())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val command: Option[List[String]] = scala
      .Option(impl.command())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val environment
        : Option[List[zio.aws.ecs.model.KeyValuePair.ReadOnly]] = scala
      .Option(impl.environment())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.KeyValuePair.wrap(item)
        }.toList
      )
    override val environmentFiles
        : Option[List[zio.aws.ecs.model.EnvironmentFile.ReadOnly]] = scala
      .Option(impl.environmentFiles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.EnvironmentFile.wrap(item)
        }.toList
      )
    override val mountPoints
        : Option[List[zio.aws.ecs.model.MountPoint.ReadOnly]] = scala
      .Option(impl.mountPoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.MountPoint.wrap(item)
        }.toList
      )
    override val volumesFrom
        : Option[List[zio.aws.ecs.model.VolumeFrom.ReadOnly]] = scala
      .Option(impl.volumesFrom())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.VolumeFrom.wrap(item)
        }.toList
      )
    override val linuxParameters
        : Option[zio.aws.ecs.model.LinuxParameters.ReadOnly] = scala
      .Option(impl.linuxParameters())
      .map(value => zio.aws.ecs.model.LinuxParameters.wrap(value))
    override val secrets: Option[List[zio.aws.ecs.model.Secret.ReadOnly]] =
      scala
        .Option(impl.secrets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Secret.wrap(item)
          }.toList
        )
    override val dependsOn
        : Option[List[zio.aws.ecs.model.ContainerDependency.ReadOnly]] = scala
      .Option(impl.dependsOn())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ContainerDependency.wrap(item)
        }.toList
      )
    override val startTimeout: Option[BoxedInteger] =
      scala.Option(impl.startTimeout()).map(value => value: BoxedInteger)
    override val stopTimeout: Option[BoxedInteger] =
      scala.Option(impl.stopTimeout()).map(value => value: BoxedInteger)
    override val hostname: Option[String] =
      scala.Option(impl.hostname()).map(value => value: String)
    override val user: Option[String] =
      scala.Option(impl.user()).map(value => value: String)
    override val workingDirectory: Option[String] =
      scala.Option(impl.workingDirectory()).map(value => value: String)
    override val disableNetworking: Option[BoxedBoolean] =
      scala.Option(impl.disableNetworking()).map(value => value: BoxedBoolean)
    override val privileged: Option[BoxedBoolean] =
      scala.Option(impl.privileged()).map(value => value: BoxedBoolean)
    override val readonlyRootFilesystem: Option[BoxedBoolean] = scala
      .Option(impl.readonlyRootFilesystem())
      .map(value => value: BoxedBoolean)
    override val dnsServers: Option[List[String]] = scala
      .Option(impl.dnsServers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val dnsSearchDomains: Option[List[String]] = scala
      .Option(impl.dnsSearchDomains())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val extraHosts
        : Option[List[zio.aws.ecs.model.HostEntry.ReadOnly]] = scala
      .Option(impl.extraHosts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.HostEntry.wrap(item)
        }.toList
      )
    override val dockerSecurityOptions: Option[List[String]] = scala
      .Option(impl.dockerSecurityOptions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val interactive: Option[BoxedBoolean] =
      scala.Option(impl.interactive()).map(value => value: BoxedBoolean)
    override val pseudoTerminal: Option[BoxedBoolean] =
      scala.Option(impl.pseudoTerminal()).map(value => value: BoxedBoolean)
    override val dockerLabels: Option[Map[String, String]] = scala
      .Option(impl.dockerLabels())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val ulimits: Option[List[zio.aws.ecs.model.Ulimit.ReadOnly]] =
      scala
        .Option(impl.ulimits())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Ulimit.wrap(item)
          }.toList
        )
    override val logConfiguration
        : Option[zio.aws.ecs.model.LogConfiguration.ReadOnly] = scala
      .Option(impl.logConfiguration())
      .map(value => zio.aws.ecs.model.LogConfiguration.wrap(value))
    override val healthCheck: Option[zio.aws.ecs.model.HealthCheck.ReadOnly] =
      scala
        .Option(impl.healthCheck())
        .map(value => zio.aws.ecs.model.HealthCheck.wrap(value))
    override val systemControls
        : Option[List[zio.aws.ecs.model.SystemControl.ReadOnly]] = scala
      .Option(impl.systemControls())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.SystemControl.wrap(item)
        }.toList
      )
    override val resourceRequirements
        : Option[List[zio.aws.ecs.model.ResourceRequirement.ReadOnly]] = scala
      .Option(impl.resourceRequirements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ResourceRequirement.wrap(item)
        }.toList
      )
    override val firelensConfiguration
        : Option[zio.aws.ecs.model.FirelensConfiguration.ReadOnly] = scala
      .Option(impl.firelensConfiguration())
      .map(value => zio.aws.ecs.model.FirelensConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ContainerDefinition
  ): zio.aws.ecs.model.ContainerDefinition.ReadOnly = new Wrapper(impl)
}
