package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.{BoxedBoolean, BoxedInteger}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateServiceRequest(
    cluster: Option[String] = None,
    service: String,
    desiredCount: Option[BoxedInteger] = None,
    taskDefinition: Option[String] = None,
    capacityProviderStrategy: Option[
      Iterable[zio.aws.ecs.model.CapacityProviderStrategyItem]
    ] = None,
    deploymentConfiguration: Option[zio.aws.ecs.model.DeploymentConfiguration] =
      None,
    networkConfiguration: Option[zio.aws.ecs.model.NetworkConfiguration] = None,
    placementConstraints: Option[
      Iterable[zio.aws.ecs.model.PlacementConstraint]
    ] = None,
    placementStrategy: Option[Iterable[zio.aws.ecs.model.PlacementStrategy]] =
      None,
    platformVersion: Option[String] = None,
    forceNewDeployment: Option[Boolean] = None,
    healthCheckGracePeriodSeconds: Option[BoxedInteger] = None,
    enableExecuteCommand: Option[BoxedBoolean] = None,
    enableECSManagedTags: Option[BoxedBoolean] = None,
    loadBalancers: Option[Iterable[zio.aws.ecs.model.LoadBalancer]] = None,
    propagateTags: Option[zio.aws.ecs.model.PropagateTags] = None,
    serviceRegistries: Option[Iterable[zio.aws.ecs.model.ServiceRegistry]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.UpdateServiceRequest = {
    import UpdateServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.UpdateServiceRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .service(service: java.lang.String)
      .optionallyWith(desiredCount.map(value => value: Integer))(_.desiredCount)
      .optionallyWith(taskDefinition.map(value => value: java.lang.String))(
        _.taskDefinition
      )
      .optionallyWith(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviderStrategy)
      .optionallyWith(
        deploymentConfiguration.map(value => value.buildAwsValue())
      )(_.deploymentConfiguration)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(
        placementConstraints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementConstraints)
      .optionallyWith(
        placementStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementStrategy)
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(
        forceNewDeployment.map(value => value: java.lang.Boolean)
      )(_.forceNewDeployment)
      .optionallyWith(
        healthCheckGracePeriodSeconds.map(value => value: Integer)
      )(_.healthCheckGracePeriodSeconds)
      .optionallyWith(
        enableExecuteCommand.map(value => value: java.lang.Boolean)
      )(_.enableExecuteCommand)
      .optionallyWith(
        enableECSManagedTags.map(value => value: java.lang.Boolean)
      )(_.enableECSManagedTags)
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .optionallyWith(propagateTags.map(value => value.unwrap))(_.propagateTags)
      .optionallyWith(
        serviceRegistries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceRegistries)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.UpdateServiceRequest.ReadOnly =
    zio.aws.ecs.model.UpdateServiceRequest.wrap(buildAwsValue())
}
object UpdateServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.UpdateServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.UpdateServiceRequest =
      zio.aws.ecs.model.UpdateServiceRequest(
        cluster.map(value => value),
        service,
        desiredCount.map(value => value),
        taskDefinition.map(value => value),
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deploymentConfiguration.map(value => value.asEditable),
        networkConfiguration.map(value => value.asEditable),
        placementConstraints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placementStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platformVersion.map(value => value),
        forceNewDeployment.map(value => value),
        healthCheckGracePeriodSeconds.map(value => value),
        enableExecuteCommand.map(value => value),
        enableECSManagedTags.map(value => value),
        loadBalancers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        propagateTags.map(value => value),
        serviceRegistries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cluster: Option[String]
    def service: String
    def desiredCount: Option[BoxedInteger]
    def taskDefinition: Option[String]
    def capacityProviderStrategy
        : Option[List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]]
    def deploymentConfiguration
        : Option[zio.aws.ecs.model.DeploymentConfiguration.ReadOnly]
    def networkConfiguration
        : Option[zio.aws.ecs.model.NetworkConfiguration.ReadOnly]
    def placementConstraints
        : Option[List[zio.aws.ecs.model.PlacementConstraint.ReadOnly]]
    def placementStrategy
        : Option[List[zio.aws.ecs.model.PlacementStrategy.ReadOnly]]
    def platformVersion: Option[String]
    def forceNewDeployment: Option[Boolean]
    def healthCheckGracePeriodSeconds: Option[BoxedInteger]
    def enableExecuteCommand: Option[BoxedBoolean]
    def enableECSManagedTags: Option[BoxedBoolean]
    def loadBalancers: Option[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]]
    def propagateTags: Option[zio.aws.ecs.model.PropagateTags]
    def serviceRegistries
        : Option[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getService: ZIO[Any, Nothing, String] = ZIO.succeed(service)
    def getDesiredCount: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("desiredCount", desiredCount)
    def getTaskDefinition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskDefinition", taskDefinition)
    def getCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityProviderStrategy",
      capacityProviderStrategy
    )
    def getDeploymentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.DeploymentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deploymentConfiguration",
      deploymentConfiguration
    )
    def getNetworkConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getPlacementConstraints: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.PlacementConstraint.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placementConstraints", placementConstraints)
    def getPlacementStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.PlacementStrategy.ReadOnly
    ]] = AwsError.unwrapOptionField("placementStrategy", placementStrategy)
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getForceNewDeployment: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("forceNewDeployment", forceNewDeployment)
    def getHealthCheckGracePeriodSeconds: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField(
        "healthCheckGracePeriodSeconds",
        healthCheckGracePeriodSeconds
      )
    def getEnableExecuteCommand: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("enableExecuteCommand", enableExecuteCommand)
    def getEnableECSManagedTags: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("enableECSManagedTags", enableECSManagedTags)
    def getLoadBalancers
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] =
      AwsError.unwrapOptionField("loadBalancers", loadBalancers)
    def getPropagateTags: ZIO[Any, AwsError, zio.aws.ecs.model.PropagateTags] =
      AwsError.unwrapOptionField("propagateTags", propagateTags)
    def getServiceRegistries
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] =
      AwsError.unwrapOptionField("serviceRegistries", serviceRegistries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.UpdateServiceRequest
  ) extends zio.aws.ecs.model.UpdateServiceRequest.ReadOnly {
    override val cluster: Option[String] =
      scala.Option(impl.cluster()).map(value => value: String)
    override val service: String = impl.service(): String
    override val desiredCount: Option[BoxedInteger] =
      scala.Option(impl.desiredCount()).map(value => value: BoxedInteger)
    override val taskDefinition: Option[String] =
      scala.Option(impl.taskDefinition()).map(value => value: String)
    override val capacityProviderStrategy: Option[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ] = scala
      .Option(impl.capacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
    override val deploymentConfiguration
        : Option[zio.aws.ecs.model.DeploymentConfiguration.ReadOnly] = scala
      .Option(impl.deploymentConfiguration())
      .map(value => zio.aws.ecs.model.DeploymentConfiguration.wrap(value))
    override val networkConfiguration
        : Option[zio.aws.ecs.model.NetworkConfiguration.ReadOnly] = scala
      .Option(impl.networkConfiguration())
      .map(value => zio.aws.ecs.model.NetworkConfiguration.wrap(value))
    override val placementConstraints
        : Option[List[zio.aws.ecs.model.PlacementConstraint.ReadOnly]] = scala
      .Option(impl.placementConstraints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.PlacementConstraint.wrap(item)
        }.toList
      )
    override val placementStrategy
        : Option[List[zio.aws.ecs.model.PlacementStrategy.ReadOnly]] = scala
      .Option(impl.placementStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.PlacementStrategy.wrap(item)
        }.toList
      )
    override val platformVersion: Option[String] =
      scala.Option(impl.platformVersion()).map(value => value: String)
    override val forceNewDeployment: Option[Boolean] =
      scala.Option(impl.forceNewDeployment()).map(value => value: Boolean)
    override val healthCheckGracePeriodSeconds: Option[BoxedInteger] = scala
      .Option(impl.healthCheckGracePeriodSeconds())
      .map(value => value: BoxedInteger)
    override val enableExecuteCommand: Option[BoxedBoolean] = scala
      .Option(impl.enableExecuteCommand())
      .map(value => value: BoxedBoolean)
    override val enableECSManagedTags: Option[BoxedBoolean] = scala
      .Option(impl.enableECSManagedTags())
      .map(value => value: BoxedBoolean)
    override val loadBalancers
        : Option[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] = scala
      .Option(impl.loadBalancers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.LoadBalancer.wrap(item)
        }.toList
      )
    override val propagateTags: Option[zio.aws.ecs.model.PropagateTags] = scala
      .Option(impl.propagateTags())
      .map(value => zio.aws.ecs.model.PropagateTags.wrap(value))
    override val serviceRegistries
        : Option[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] = scala
      .Option(impl.serviceRegistries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ServiceRegistry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.UpdateServiceRequest
  ): zio.aws.ecs.model.UpdateServiceRequest.ReadOnly = new Wrapper(impl)
}
