package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAccountSettingsRequest(
    name: Option[zio.aws.ecs.model.SettingName] = None,
    value: Option[String] = None,
    principalArn: Option[String] = None,
    effectiveSettings: Option[Boolean] = None,
    nextToken: Option[String] = None,
    maxResults: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest = {
    import ListAccountSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(principalArn.map(value => value: java.lang.String))(
        _.principalArn
      )
      .optionallyWith(effectiveSettings.map(value => value: java.lang.Boolean))(
        _.effectiveSettings
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListAccountSettingsRequest.ReadOnly =
    zio.aws.ecs.model.ListAccountSettingsRequest.wrap(buildAwsValue())
}
object ListAccountSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListAccountSettingsRequest =
      zio.aws.ecs.model.ListAccountSettingsRequest(
        name.map(value => value),
        value.map(value => value),
        principalArn.map(value => value),
        effectiveSettings.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def name: Option[zio.aws.ecs.model.SettingName]
    def value: Option[String]
    def principalArn: Option[String]
    def effectiveSettings: Option[Boolean]
    def nextToken: Option[String]
    def maxResults: Option[Integer]
    def getName: ZIO[Any, AwsError, zio.aws.ecs.model.SettingName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getPrincipalArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principalArn", principalArn)
    def getEffectiveSettings: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("effectiveSettings", effectiveSettings)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest
  ) extends zio.aws.ecs.model.ListAccountSettingsRequest.ReadOnly {
    override val name: Option[zio.aws.ecs.model.SettingName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ecs.model.SettingName.wrap(value))
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
    override val principalArn: Option[String] =
      scala.Option(impl.principalArn()).map(value => value: String)
    override val effectiveSettings: Option[Boolean] =
      scala.Option(impl.effectiveSettings()).map(value => value: Boolean)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest
  ): zio.aws.ecs.model.ListAccountSettingsRequest.ReadOnly = new Wrapper(impl)
}
