package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTaskDefinitionResponse(
    taskDefinition: Option[zio.aws.ecs.model.TaskDefinition] = None,
    tags: Option[Iterable[zio.aws.ecs.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DescribeTaskDefinitionResponse = {
    import DescribeTaskDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DescribeTaskDefinitionResponse
      .builder()
      .optionallyWith(taskDefinition.map(value => value.buildAwsValue()))(
        _.taskDefinition
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DescribeTaskDefinitionResponse.ReadOnly =
    zio.aws.ecs.model.DescribeTaskDefinitionResponse.wrap(buildAwsValue())
}
object DescribeTaskDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DescribeTaskDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DescribeTaskDefinitionResponse =
      zio.aws.ecs.model.DescribeTaskDefinitionResponse(
        taskDefinition.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def taskDefinition: Option[zio.aws.ecs.model.TaskDefinition.ReadOnly]
    def tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def getTaskDefinition
        : ZIO[Any, AwsError, zio.aws.ecs.model.TaskDefinition.ReadOnly] =
      AwsError.unwrapOptionField("taskDefinition", taskDefinition)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DescribeTaskDefinitionResponse
  ) extends zio.aws.ecs.model.DescribeTaskDefinitionResponse.ReadOnly {
    override val taskDefinition
        : Option[zio.aws.ecs.model.TaskDefinition.ReadOnly] = scala
      .Option(impl.taskDefinition())
      .map(value => zio.aws.ecs.model.TaskDefinition.wrap(value))
    override val tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DescribeTaskDefinitionResponse
  ): zio.aws.ecs.model.DescribeTaskDefinitionResponse.ReadOnly = new Wrapper(
    impl
  )
}
