package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.{
  CapacityProviderStrategyItemBase,
  CapacityProviderStrategyItemWeight
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CapacityProviderStrategyItem(
    capacityProvider: String,
    weight: Option[CapacityProviderStrategyItemWeight] = None,
    base: Option[CapacityProviderStrategyItemBase] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem = {
    import CapacityProviderStrategyItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem
      .builder()
      .capacityProvider(capacityProvider: java.lang.String)
      .optionallyWith(
        weight.map(value =>
          CapacityProviderStrategyItemWeight.unwrap(value): Integer
        )
      )(_.weight)
      .optionallyWith(
        base.map(value =>
          CapacityProviderStrategyItemBase.unwrap(value): Integer
        )
      )(_.base)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly =
    zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(buildAwsValue())
}
object CapacityProviderStrategyItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.CapacityProviderStrategyItem =
      zio.aws.ecs.model.CapacityProviderStrategyItem(
        capacityProvider,
        weight.map(value => value),
        base.map(value => value)
      )
    def capacityProvider: String
    def weight: Option[CapacityProviderStrategyItemWeight]
    def base: Option[CapacityProviderStrategyItemBase]
    def getCapacityProvider: ZIO[Any, Nothing, String] =
      ZIO.succeed(capacityProvider)
    def getWeight: ZIO[Any, AwsError, CapacityProviderStrategyItemWeight] =
      AwsError.unwrapOptionField("weight", weight)
    def getBase: ZIO[Any, AwsError, CapacityProviderStrategyItemBase] =
      AwsError.unwrapOptionField("base", base)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem
  ) extends zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly {
    override val capacityProvider: String = impl.capacityProvider(): String
    override val weight: Option[CapacityProviderStrategyItemWeight] = scala
      .Option(impl.weight())
      .map(value =>
        zio.aws.ecs.model.primitives.CapacityProviderStrategyItemWeight(value)
      )
    override val base: Option[CapacityProviderStrategyItemBase] = scala
      .Option(impl.base())
      .map(value =>
        zio.aws.ecs.model.primitives.CapacityProviderStrategyItemBase(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem
  ): zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly = new Wrapper(impl)
}
