package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.{Timestamp, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TaskSet(
    id: Option[String] = None,
    taskSetArn: Option[String] = None,
    serviceArn: Option[String] = None,
    clusterArn: Option[String] = None,
    startedBy: Option[String] = None,
    externalId: Option[String] = None,
    status: Option[String] = None,
    taskDefinition: Option[String] = None,
    computedDesiredCount: Option[Integer] = None,
    pendingCount: Option[Integer] = None,
    runningCount: Option[Integer] = None,
    createdAt: Option[Timestamp] = None,
    updatedAt: Option[Timestamp] = None,
    launchType: Option[zio.aws.ecs.model.LaunchType] = None,
    capacityProviderStrategy: Option[
      Iterable[zio.aws.ecs.model.CapacityProviderStrategyItem]
    ] = None,
    platformVersion: Option[String] = None,
    platformFamily: Option[String] = None,
    networkConfiguration: Option[zio.aws.ecs.model.NetworkConfiguration] = None,
    loadBalancers: Option[Iterable[zio.aws.ecs.model.LoadBalancer]] = None,
    serviceRegistries: Option[Iterable[zio.aws.ecs.model.ServiceRegistry]] =
      None,
    scale: Option[zio.aws.ecs.model.Scale] = None,
    stabilityStatus: Option[zio.aws.ecs.model.StabilityStatus] = None,
    stabilityStatusAt: Option[Timestamp] = None,
    tags: Option[Iterable[zio.aws.ecs.model.Tag]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.TaskSet = {
    import TaskSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.TaskSet
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(taskSetArn.map(value => value: java.lang.String))(
        _.taskSetArn
      )
      .optionallyWith(serviceArn.map(value => value: java.lang.String))(
        _.serviceArn
      )
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(startedBy.map(value => value: java.lang.String))(
        _.startedBy
      )
      .optionallyWith(externalId.map(value => value: java.lang.String))(
        _.externalId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(taskDefinition.map(value => value: java.lang.String))(
        _.taskDefinition
      )
      .optionallyWith(
        computedDesiredCount.map(value => value: java.lang.Integer)
      )(_.computedDesiredCount)
      .optionallyWith(pendingCount.map(value => value: java.lang.Integer))(
        _.pendingCount
      )
      .optionallyWith(runningCount.map(value => value: java.lang.Integer))(
        _.runningCount
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .optionallyWith(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviderStrategy)
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(platformFamily.map(value => value: java.lang.String))(
        _.platformFamily
      )
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .optionallyWith(
        serviceRegistries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceRegistries)
      .optionallyWith(scale.map(value => value.buildAwsValue()))(_.scale)
      .optionallyWith(stabilityStatus.map(value => value.unwrap))(
        _.stabilityStatus
      )
      .optionallyWith(
        stabilityStatusAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.stabilityStatusAt)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.TaskSet.ReadOnly =
    zio.aws.ecs.model.TaskSet.wrap(buildAwsValue())
}
object TaskSet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.TaskSet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.TaskSet = zio.aws.ecs.model.TaskSet(
      id.map(value => value),
      taskSetArn.map(value => value),
      serviceArn.map(value => value),
      clusterArn.map(value => value),
      startedBy.map(value => value),
      externalId.map(value => value),
      status.map(value => value),
      taskDefinition.map(value => value),
      computedDesiredCount.map(value => value),
      pendingCount.map(value => value),
      runningCount.map(value => value),
      createdAt.map(value => value),
      updatedAt.map(value => value),
      launchType.map(value => value),
      capacityProviderStrategy.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      platformVersion.map(value => value),
      platformFamily.map(value => value),
      networkConfiguration.map(value => value.asEditable),
      loadBalancers.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      serviceRegistries.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      scale.map(value => value.asEditable),
      stabilityStatus.map(value => value),
      stabilityStatusAt.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def id: Option[String]
    def taskSetArn: Option[String]
    def serviceArn: Option[String]
    def clusterArn: Option[String]
    def startedBy: Option[String]
    def externalId: Option[String]
    def status: Option[String]
    def taskDefinition: Option[String]
    def computedDesiredCount: Option[Integer]
    def pendingCount: Option[Integer]
    def runningCount: Option[Integer]
    def createdAt: Option[Timestamp]
    def updatedAt: Option[Timestamp]
    def launchType: Option[zio.aws.ecs.model.LaunchType]
    def capacityProviderStrategy
        : Option[List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]]
    def platformVersion: Option[String]
    def platformFamily: Option[String]
    def networkConfiguration
        : Option[zio.aws.ecs.model.NetworkConfiguration.ReadOnly]
    def loadBalancers: Option[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]]
    def serviceRegistries
        : Option[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]]
    def scale: Option[zio.aws.ecs.model.Scale.ReadOnly]
    def stabilityStatus: Option[zio.aws.ecs.model.StabilityStatus]
    def stabilityStatusAt: Option[Timestamp]
    def tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getTaskSetArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskSetArn", taskSetArn)
    def getServiceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceArn", serviceArn)
    def getClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getStartedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startedBy", startedBy)
    def getExternalId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getTaskDefinition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskDefinition", taskDefinition)
    def getComputedDesiredCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("computedDesiredCount", computedDesiredCount)
    def getPendingCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("pendingCount", pendingCount)
    def getRunningCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("runningCount", runningCount)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getLaunchType: ZIO[Any, AwsError, zio.aws.ecs.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityProviderStrategy",
      capacityProviderStrategy
    )
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getPlatformFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformFamily", platformFamily)
    def getNetworkConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getLoadBalancers
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] =
      AwsError.unwrapOptionField("loadBalancers", loadBalancers)
    def getServiceRegistries
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] =
      AwsError.unwrapOptionField("serviceRegistries", serviceRegistries)
    def getScale: ZIO[Any, AwsError, zio.aws.ecs.model.Scale.ReadOnly] =
      AwsError.unwrapOptionField("scale", scale)
    def getStabilityStatus
        : ZIO[Any, AwsError, zio.aws.ecs.model.StabilityStatus] =
      AwsError.unwrapOptionField("stabilityStatus", stabilityStatus)
    def getStabilityStatusAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("stabilityStatusAt", stabilityStatusAt)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.TaskSet
  ) extends zio.aws.ecs.model.TaskSet.ReadOnly {
    override val id: Option[String] =
      scala.Option(impl.id()).map(value => value: String)
    override val taskSetArn: Option[String] =
      scala.Option(impl.taskSetArn()).map(value => value: String)
    override val serviceArn: Option[String] =
      scala.Option(impl.serviceArn()).map(value => value: String)
    override val clusterArn: Option[String] =
      scala.Option(impl.clusterArn()).map(value => value: String)
    override val startedBy: Option[String] =
      scala.Option(impl.startedBy()).map(value => value: String)
    override val externalId: Option[String] =
      scala.Option(impl.externalId()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val taskDefinition: Option[String] =
      scala.Option(impl.taskDefinition()).map(value => value: String)
    override val computedDesiredCount: Option[Integer] =
      scala.Option(impl.computedDesiredCount()).map(value => value: Integer)
    override val pendingCount: Option[Integer] =
      scala.Option(impl.pendingCount()).map(value => value: Integer)
    override val runningCount: Option[Integer] =
      scala.Option(impl.runningCount()).map(value => value: Integer)
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val launchType: Option[zio.aws.ecs.model.LaunchType] = scala
      .Option(impl.launchType())
      .map(value => zio.aws.ecs.model.LaunchType.wrap(value))
    override val capacityProviderStrategy: Option[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ] = scala
      .Option(impl.capacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
    override val platformVersion: Option[String] =
      scala.Option(impl.platformVersion()).map(value => value: String)
    override val platformFamily: Option[String] =
      scala.Option(impl.platformFamily()).map(value => value: String)
    override val networkConfiguration
        : Option[zio.aws.ecs.model.NetworkConfiguration.ReadOnly] = scala
      .Option(impl.networkConfiguration())
      .map(value => zio.aws.ecs.model.NetworkConfiguration.wrap(value))
    override val loadBalancers
        : Option[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] = scala
      .Option(impl.loadBalancers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.LoadBalancer.wrap(item)
        }.toList
      )
    override val serviceRegistries
        : Option[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] = scala
      .Option(impl.serviceRegistries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ServiceRegistry.wrap(item)
        }.toList
      )
    override val scale: Option[zio.aws.ecs.model.Scale.ReadOnly] = scala
      .Option(impl.scale())
      .map(value => zio.aws.ecs.model.Scale.wrap(value))
    override val stabilityStatus: Option[zio.aws.ecs.model.StabilityStatus] =
      scala
        .Option(impl.stabilityStatus())
        .map(value => zio.aws.ecs.model.StabilityStatus.wrap(value))
    override val stabilityStatusAt: Option[Timestamp] = scala
      .Option(impl.stabilityStatusAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.TaskSet
  ): zio.aws.ecs.model.TaskSet.ReadOnly = new Wrapper(impl)
}
