package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Resource(
    name: Option[String] = None,
    `type`: Option[String] = None,
    doubleValue: Option[Double] = None,
    longValue: Option[Long] = None,
    integerValue: Option[Integer] = None,
    stringSetValue: Option[Iterable[String]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Resource = {
    import Resource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Resource
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(doubleValue.map(value => value: java.lang.Double))(
        _.doubleValue
      )
      .optionallyWith(longValue.map(value => value: java.lang.Long))(
        _.longValue
      )
      .optionallyWith(integerValue.map(value => value: java.lang.Integer))(
        _.integerValue
      )
      .optionallyWith(
        stringSetValue.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.stringSetValue)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Resource.ReadOnly =
    zio.aws.ecs.model.Resource.wrap(buildAwsValue())
}
object Resource {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Resource] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Resource = zio.aws.ecs.model.Resource(
      name.map(value => value),
      `type`.map(value => value),
      doubleValue.map(value => value),
      longValue.map(value => value),
      integerValue.map(value => value),
      stringSetValue.map(value => value)
    )
    def name: Option[String]
    def `type`: Option[String]
    def doubleValue: Option[Double]
    def longValue: Option[Long]
    def integerValue: Option[Integer]
    def stringSetValue: Option[List[String]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getDoubleValue: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("doubleValue", doubleValue)
    def getLongValue: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("longValue", longValue)
    def getIntegerValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("integerValue", integerValue)
    def getStringSetValue: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("stringSetValue", stringSetValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Resource
  ) extends zio.aws.ecs.model.Resource.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val `type`: Option[String] =
      scala.Option(impl.`type`()).map(value => value: String)
    override val doubleValue: Option[Double] =
      scala.Option(impl.doubleValue()).map(value => value: Double)
    override val longValue: Option[Long] =
      scala.Option(impl.longValue()).map(value => value: Long)
    override val integerValue: Option[Integer] =
      scala.Option(impl.integerValue()).map(value => value: Integer)
    override val stringSetValue: Option[List[String]] = scala
      .Option(impl.stringSetValue())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Resource
  ): zio.aws.ecs.model.Resource.ReadOnly = new Wrapper(impl)
}
