package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAttributesRequest(
    cluster: Option[String] = None,
    targetType: zio.aws.ecs.model.TargetType,
    attributeName: Option[String] = None,
    attributeValue: Option[String] = None,
    nextToken: Option[String] = None,
    maxResults: Option[BoxedInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListAttributesRequest = {
    import ListAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListAttributesRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .targetType(targetType.unwrap)
      .optionallyWith(attributeName.map(value => value: java.lang.String))(
        _.attributeName
      )
      .optionallyWith(attributeValue.map(value => value: java.lang.String))(
        _.attributeValue
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListAttributesRequest.ReadOnly =
    zio.aws.ecs.model.ListAttributesRequest.wrap(buildAwsValue())
}
object ListAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListAttributesRequest =
      zio.aws.ecs.model.ListAttributesRequest(
        cluster.map(value => value),
        targetType,
        attributeName.map(value => value),
        attributeValue.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def cluster: Option[String]
    def targetType: zio.aws.ecs.model.TargetType
    def attributeName: Option[String]
    def attributeValue: Option[String]
    def nextToken: Option[String]
    def maxResults: Option[BoxedInteger]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getTargetType: ZIO[Any, Nothing, zio.aws.ecs.model.TargetType] =
      ZIO.succeed(targetType)
    def getAttributeName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getAttributeValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attributeValue", attributeValue)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListAttributesRequest
  ) extends zio.aws.ecs.model.ListAttributesRequest.ReadOnly {
    override val cluster: Option[String] =
      scala.Option(impl.cluster()).map(value => value: String)
    override val targetType: zio.aws.ecs.model.TargetType =
      zio.aws.ecs.model.TargetType.wrap(impl.targetType())
    override val attributeName: Option[String] =
      scala.Option(impl.attributeName()).map(value => value: String)
    override val attributeValue: Option[String] =
      scala.Option(impl.attributeValue()).map(value => value: String)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[BoxedInteger] =
      scala.Option(impl.maxResults()).map(value => value: BoxedInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListAttributesRequest
  ): zio.aws.ecs.model.ListAttributesRequest.ReadOnly = new Wrapper(impl)
}
