package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.{Timestamp, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TaskDefinition(
    taskDefinitionArn: Option[String] = None,
    containerDefinitions: Option[
      Iterable[zio.aws.ecs.model.ContainerDefinition]
    ] = None,
    family: Option[String] = None,
    taskRoleArn: Option[String] = None,
    executionRoleArn: Option[String] = None,
    networkMode: Option[zio.aws.ecs.model.NetworkMode] = None,
    revision: Option[Integer] = None,
    volumes: Option[Iterable[zio.aws.ecs.model.Volume]] = None,
    status: Option[zio.aws.ecs.model.TaskDefinitionStatus] = None,
    requiresAttributes: Option[Iterable[zio.aws.ecs.model.Attribute]] = None,
    placementConstraints: Option[
      Iterable[zio.aws.ecs.model.TaskDefinitionPlacementConstraint]
    ] = None,
    compatibilities: Option[Iterable[zio.aws.ecs.model.Compatibility]] = None,
    runtimePlatform: Option[zio.aws.ecs.model.RuntimePlatform] = None,
    requiresCompatibilities: Option[Iterable[zio.aws.ecs.model.Compatibility]] =
      None,
    cpu: Option[String] = None,
    memory: Option[String] = None,
    inferenceAccelerators: Option[
      Iterable[zio.aws.ecs.model.InferenceAccelerator]
    ] = None,
    pidMode: Option[zio.aws.ecs.model.PidMode] = None,
    ipcMode: Option[zio.aws.ecs.model.IpcMode] = None,
    proxyConfiguration: Option[zio.aws.ecs.model.ProxyConfiguration] = None,
    registeredAt: Option[Timestamp] = None,
    deregisteredAt: Option[Timestamp] = None,
    registeredBy: Option[String] = None,
    ephemeralStorage: Option[zio.aws.ecs.model.EphemeralStorage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.TaskDefinition = {
    import TaskDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.TaskDefinition
      .builder()
      .optionallyWith(taskDefinitionArn.map(value => value: java.lang.String))(
        _.taskDefinitionArn
      )
      .optionallyWith(
        containerDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containerDefinitions)
      .optionallyWith(family.map(value => value: java.lang.String))(_.family)
      .optionallyWith(taskRoleArn.map(value => value: java.lang.String))(
        _.taskRoleArn
      )
      .optionallyWith(executionRoleArn.map(value => value: java.lang.String))(
        _.executionRoleArn
      )
      .optionallyWith(networkMode.map(value => value.unwrap))(_.networkMode)
      .optionallyWith(
        revision.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.revision)
      .optionallyWith(
        volumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumes)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        requiresAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requiresAttributes)
      .optionallyWith(
        placementConstraints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementConstraints)
      .optionallyWith(
        compatibilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.compatibilitiesWithStrings)
      .optionallyWith(runtimePlatform.map(value => value.buildAwsValue()))(
        _.runtimePlatform
      )
      .optionallyWith(
        requiresCompatibilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.requiresCompatibilitiesWithStrings)
      .optionallyWith(cpu.map(value => value: java.lang.String))(_.cpu)
      .optionallyWith(memory.map(value => value: java.lang.String))(_.memory)
      .optionallyWith(
        inferenceAccelerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inferenceAccelerators)
      .optionallyWith(pidMode.map(value => value.unwrap))(_.pidMode)
      .optionallyWith(ipcMode.map(value => value.unwrap))(_.ipcMode)
      .optionallyWith(proxyConfiguration.map(value => value.buildAwsValue()))(
        _.proxyConfiguration
      )
      .optionallyWith(
        registeredAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.registeredAt)
      .optionallyWith(
        deregisteredAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.deregisteredAt)
      .optionallyWith(registeredBy.map(value => value: java.lang.String))(
        _.registeredBy
      )
      .optionallyWith(ephemeralStorage.map(value => value.buildAwsValue()))(
        _.ephemeralStorage
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.TaskDefinition.ReadOnly =
    zio.aws.ecs.model.TaskDefinition.wrap(buildAwsValue())
}
object TaskDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.TaskDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.TaskDefinition =
      zio.aws.ecs.model.TaskDefinition(
        taskDefinitionArn.map(value => value),
        containerDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        family.map(value => value),
        taskRoleArn.map(value => value),
        executionRoleArn.map(value => value),
        networkMode.map(value => value),
        revision.map(value => value),
        volumes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        requiresAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placementConstraints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        compatibilities.map(value => value),
        runtimePlatform.map(value => value.asEditable),
        requiresCompatibilities.map(value => value),
        cpu.map(value => value),
        memory.map(value => value),
        inferenceAccelerators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pidMode.map(value => value),
        ipcMode.map(value => value),
        proxyConfiguration.map(value => value.asEditable),
        registeredAt.map(value => value),
        deregisteredAt.map(value => value),
        registeredBy.map(value => value),
        ephemeralStorage.map(value => value.asEditable)
      )
    def taskDefinitionArn: Option[String]
    def containerDefinitions
        : Option[List[zio.aws.ecs.model.ContainerDefinition.ReadOnly]]
    def family: Option[String]
    def taskRoleArn: Option[String]
    def executionRoleArn: Option[String]
    def networkMode: Option[zio.aws.ecs.model.NetworkMode]
    def revision: Option[Integer]
    def volumes: Option[List[zio.aws.ecs.model.Volume.ReadOnly]]
    def status: Option[zio.aws.ecs.model.TaskDefinitionStatus]
    def requiresAttributes: Option[List[zio.aws.ecs.model.Attribute.ReadOnly]]
    def placementConstraints: Option[
      List[zio.aws.ecs.model.TaskDefinitionPlacementConstraint.ReadOnly]
    ]
    def compatibilities: Option[List[zio.aws.ecs.model.Compatibility]]
    def runtimePlatform: Option[zio.aws.ecs.model.RuntimePlatform.ReadOnly]
    def requiresCompatibilities: Option[List[zio.aws.ecs.model.Compatibility]]
    def cpu: Option[String]
    def memory: Option[String]
    def inferenceAccelerators
        : Option[List[zio.aws.ecs.model.InferenceAccelerator.ReadOnly]]
    def pidMode: Option[zio.aws.ecs.model.PidMode]
    def ipcMode: Option[zio.aws.ecs.model.IpcMode]
    def proxyConfiguration
        : Option[zio.aws.ecs.model.ProxyConfiguration.ReadOnly]
    def registeredAt: Option[Timestamp]
    def deregisteredAt: Option[Timestamp]
    def registeredBy: Option[String]
    def ephemeralStorage: Option[zio.aws.ecs.model.EphemeralStorage.ReadOnly]
    def getTaskDefinitionArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskDefinitionArn", taskDefinitionArn)
    def getContainerDefinitions: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.ContainerDefinition.ReadOnly
    ]] =
      AwsError.unwrapOptionField("containerDefinitions", containerDefinitions)
    def getFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("family", family)
    def getTaskRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskRoleArn", taskRoleArn)
    def getExecutionRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getNetworkMode: ZIO[Any, AwsError, zio.aws.ecs.model.NetworkMode] =
      AwsError.unwrapOptionField("networkMode", networkMode)
    def getRevision: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("revision", revision)
    def getVolumes
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Volume.ReadOnly]] =
      AwsError.unwrapOptionField("volumes", volumes)
    def getStatus: ZIO[Any, AwsError, zio.aws.ecs.model.TaskDefinitionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRequiresAttributes
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Attribute.ReadOnly]] =
      AwsError.unwrapOptionField("requiresAttributes", requiresAttributes)
    def getPlacementConstraints: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.TaskDefinitionPlacementConstraint.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placementConstraints", placementConstraints)
    def getCompatibilities
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Compatibility]] =
      AwsError.unwrapOptionField("compatibilities", compatibilities)
    def getRuntimePlatform
        : ZIO[Any, AwsError, zio.aws.ecs.model.RuntimePlatform.ReadOnly] =
      AwsError.unwrapOptionField("runtimePlatform", runtimePlatform)
    def getRequiresCompatibilities
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Compatibility]] = AwsError
      .unwrapOptionField("requiresCompatibilities", requiresCompatibilities)
    def getCpu: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getMemory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("memory", memory)
    def getInferenceAccelerators: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.InferenceAccelerator.ReadOnly
    ]] =
      AwsError.unwrapOptionField("inferenceAccelerators", inferenceAccelerators)
    def getPidMode: ZIO[Any, AwsError, zio.aws.ecs.model.PidMode] =
      AwsError.unwrapOptionField("pidMode", pidMode)
    def getIpcMode: ZIO[Any, AwsError, zio.aws.ecs.model.IpcMode] =
      AwsError.unwrapOptionField("ipcMode", ipcMode)
    def getProxyConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.ProxyConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("proxyConfiguration", proxyConfiguration)
    def getRegisteredAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("registeredAt", registeredAt)
    def getDeregisteredAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deregisteredAt", deregisteredAt)
    def getRegisteredBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("registeredBy", registeredBy)
    def getEphemeralStorage
        : ZIO[Any, AwsError, zio.aws.ecs.model.EphemeralStorage.ReadOnly] =
      AwsError.unwrapOptionField("ephemeralStorage", ephemeralStorage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.TaskDefinition
  ) extends zio.aws.ecs.model.TaskDefinition.ReadOnly {
    override val taskDefinitionArn: Option[String] =
      scala.Option(impl.taskDefinitionArn()).map(value => value: String)
    override val containerDefinitions
        : Option[List[zio.aws.ecs.model.ContainerDefinition.ReadOnly]] = scala
      .Option(impl.containerDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ContainerDefinition.wrap(item)
        }.toList
      )
    override val family: Option[String] =
      scala.Option(impl.family()).map(value => value: String)
    override val taskRoleArn: Option[String] =
      scala.Option(impl.taskRoleArn()).map(value => value: String)
    override val executionRoleArn: Option[String] =
      scala.Option(impl.executionRoleArn()).map(value => value: String)
    override val networkMode: Option[zio.aws.ecs.model.NetworkMode] = scala
      .Option(impl.networkMode())
      .map(value => zio.aws.ecs.model.NetworkMode.wrap(value))
    override val revision: Option[Integer] = scala
      .Option(impl.revision())
      .map(value => zio.aws.ecs.model.primitives.Integer(value))
    override val volumes: Option[List[zio.aws.ecs.model.Volume.ReadOnly]] =
      scala
        .Option(impl.volumes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Volume.wrap(item)
          }.toList
        )
    override val status: Option[zio.aws.ecs.model.TaskDefinitionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ecs.model.TaskDefinitionStatus.wrap(value))
    override val requiresAttributes
        : Option[List[zio.aws.ecs.model.Attribute.ReadOnly]] = scala
      .Option(impl.requiresAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Attribute.wrap(item)
        }.toList
      )
    override val placementConstraints: Option[
      List[zio.aws.ecs.model.TaskDefinitionPlacementConstraint.ReadOnly]
    ] = scala
      .Option(impl.placementConstraints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.TaskDefinitionPlacementConstraint.wrap(item)
        }.toList
      )
    override val compatibilities
        : Option[List[zio.aws.ecs.model.Compatibility]] = scala
      .Option(impl.compatibilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Compatibility.wrap(item)
        }.toList
      )
    override val runtimePlatform
        : Option[zio.aws.ecs.model.RuntimePlatform.ReadOnly] = scala
      .Option(impl.runtimePlatform())
      .map(value => zio.aws.ecs.model.RuntimePlatform.wrap(value))
    override val requiresCompatibilities
        : Option[List[zio.aws.ecs.model.Compatibility]] = scala
      .Option(impl.requiresCompatibilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Compatibility.wrap(item)
        }.toList
      )
    override val cpu: Option[String] =
      scala.Option(impl.cpu()).map(value => value: String)
    override val memory: Option[String] =
      scala.Option(impl.memory()).map(value => value: String)
    override val inferenceAccelerators
        : Option[List[zio.aws.ecs.model.InferenceAccelerator.ReadOnly]] = scala
      .Option(impl.inferenceAccelerators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.InferenceAccelerator.wrap(item)
        }.toList
      )
    override val pidMode: Option[zio.aws.ecs.model.PidMode] = scala
      .Option(impl.pidMode())
      .map(value => zio.aws.ecs.model.PidMode.wrap(value))
    override val ipcMode: Option[zio.aws.ecs.model.IpcMode] = scala
      .Option(impl.ipcMode())
      .map(value => zio.aws.ecs.model.IpcMode.wrap(value))
    override val proxyConfiguration
        : Option[zio.aws.ecs.model.ProxyConfiguration.ReadOnly] = scala
      .Option(impl.proxyConfiguration())
      .map(value => zio.aws.ecs.model.ProxyConfiguration.wrap(value))
    override val registeredAt: Option[Timestamp] = scala
      .Option(impl.registeredAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val deregisteredAt: Option[Timestamp] = scala
      .Option(impl.deregisteredAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val registeredBy: Option[String] =
      scala.Option(impl.registeredBy()).map(value => value: String)
    override val ephemeralStorage
        : Option[zio.aws.ecs.model.EphemeralStorage.ReadOnly] = scala
      .Option(impl.ephemeralStorage())
      .map(value => zio.aws.ecs.model.EphemeralStorage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.TaskDefinition
  ): zio.aws.ecs.model.TaskDefinition.ReadOnly = new Wrapper(impl)
}
