package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeServicesResponse(
    services: Option[Iterable[zio.aws.ecs.model.Service]] = None,
    failures: Option[Iterable[zio.aws.ecs.model.Failure]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DescribeServicesResponse = {
    import DescribeServicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DescribeServicesResponse
      .builder()
      .optionallyWith(
        services.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.services)
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DescribeServicesResponse.ReadOnly =
    zio.aws.ecs.model.DescribeServicesResponse.wrap(buildAwsValue())
}
object DescribeServicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DescribeServicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DescribeServicesResponse =
      zio.aws.ecs.model.DescribeServicesResponse(
        services.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def services: Option[List[zio.aws.ecs.model.Service.ReadOnly]]
    def failures: Option[List[zio.aws.ecs.model.Failure.ReadOnly]]
    def getServices
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Service.ReadOnly]] =
      AwsError.unwrapOptionField("services", services)
    def getFailures
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Failure.ReadOnly]] =
      AwsError.unwrapOptionField("failures", failures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DescribeServicesResponse
  ) extends zio.aws.ecs.model.DescribeServicesResponse.ReadOnly {
    override val services: Option[List[zio.aws.ecs.model.Service.ReadOnly]] =
      scala
        .Option(impl.services())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Service.wrap(item)
          }.toList
        )
    override val failures: Option[List[zio.aws.ecs.model.Failure.ReadOnly]] =
      scala
        .Option(impl.failures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Failure.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DescribeServicesResponse
  ): zio.aws.ecs.model.DescribeServicesResponse.ReadOnly = new Wrapper(impl)
}
