package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KernelCapabilities(
    add: Option[Iterable[String]] = None,
    drop: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.KernelCapabilities = {
    import KernelCapabilities.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.KernelCapabilities
      .builder()
      .optionallyWith(
        add.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.add)
      .optionallyWith(
        drop.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.drop)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.KernelCapabilities.ReadOnly =
    zio.aws.ecs.model.KernelCapabilities.wrap(buildAwsValue())
}
object KernelCapabilities {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.KernelCapabilities
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.KernelCapabilities = zio.aws.ecs.model
      .KernelCapabilities(add.map(value => value), drop.map(value => value))
    def add: Option[List[String]]
    def drop: Option[List[String]]
    def getAdd: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("add", add)
    def getDrop: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("drop", drop)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.KernelCapabilities
  ) extends zio.aws.ecs.model.KernelCapabilities.ReadOnly {
    override val add: Option[List[String]] = scala
      .Option(impl.add())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val drop: Option[List[String]] = scala
      .Option(impl.drop())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.KernelCapabilities
  ): zio.aws.ecs.model.KernelCapabilities.ReadOnly = new Wrapper(impl)
}
