package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait DesiredStatus {
  def unwrap: software.amazon.awssdk.services.ecs.model.DesiredStatus
}
object DesiredStatus {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.DesiredStatus
  ): zio.aws.ecs.model.DesiredStatus = value match {
    case software.amazon.awssdk.services.ecs.model.DesiredStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.DesiredStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.ecs.model.DesiredStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.ecs.model.DesiredStatus.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.DesiredStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.DesiredStatus =
      software.amazon.awssdk.services.ecs.model.DesiredStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING extends zio.aws.ecs.model.DesiredStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.DesiredStatus =
      software.amazon.awssdk.services.ecs.model.DesiredStatus.RUNNING
  }
  case object PENDING extends zio.aws.ecs.model.DesiredStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.DesiredStatus =
      software.amazon.awssdk.services.ecs.model.DesiredStatus.PENDING
  }
  case object STOPPED extends zio.aws.ecs.model.DesiredStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.DesiredStatus =
      software.amazon.awssdk.services.ecs.model.DesiredStatus.STOPPED
  }
}
