package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Ulimit(
    name: zio.aws.ecs.model.UlimitName,
    softLimit: Integer,
    hardLimit: Integer
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Ulimit = {
    import Ulimit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Ulimit
      .builder()
      .name(name.unwrap)
      .softLimit(Integer.unwrap(softLimit): java.lang.Integer)
      .hardLimit(Integer.unwrap(hardLimit): java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Ulimit.ReadOnly =
    zio.aws.ecs.model.Ulimit.wrap(buildAwsValue())
}
object Ulimit {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Ulimit] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Ulimit =
      zio.aws.ecs.model.Ulimit(name, softLimit, hardLimit)
    def name: zio.aws.ecs.model.UlimitName
    def softLimit: Integer
    def hardLimit: Integer
    def getName: ZIO[Any, Nothing, zio.aws.ecs.model.UlimitName] =
      ZIO.succeed(name)
    def getSoftLimit: ZIO[Any, Nothing, Integer] = ZIO.succeed(softLimit)
    def getHardLimit: ZIO[Any, Nothing, Integer] = ZIO.succeed(hardLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Ulimit
  ) extends zio.aws.ecs.model.Ulimit.ReadOnly {
    override val name: zio.aws.ecs.model.UlimitName =
      zio.aws.ecs.model.UlimitName.wrap(impl.name())
    override val softLimit: Integer =
      zio.aws.ecs.model.primitives.Integer(impl.softLimit())
    override val hardLimit: Integer =
      zio.aws.ecs.model.primitives.Integer(impl.hardLimit())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Ulimit
  ): zio.aws.ecs.model.Ulimit.ReadOnly = new Wrapper(impl)
}
