package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait TaskStopCode {
  def unwrap: software.amazon.awssdk.services.ecs.model.TaskStopCode
}
object TaskStopCode {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.TaskStopCode
  ): zio.aws.ecs.model.TaskStopCode = value match {
    case software.amazon.awssdk.services.ecs.model.TaskStopCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.TaskStopCode.TASK_FAILED_TO_START =>
      val r = TaskFailedToStart
      r
    case software.amazon.awssdk.services.ecs.model.TaskStopCode.ESSENTIAL_CONTAINER_EXITED =>
      val r = EssentialContainerExited
      r
    case software.amazon.awssdk.services.ecs.model.TaskStopCode.USER_INITIATED =>
      val r = UserInitiated
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.TaskStopCode {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.TaskStopCode =
      software.amazon.awssdk.services.ecs.model.TaskStopCode.UNKNOWN_TO_SDK_VERSION
  }
  case object TaskFailedToStart extends zio.aws.ecs.model.TaskStopCode {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.TaskStopCode =
      software.amazon.awssdk.services.ecs.model.TaskStopCode.TASK_FAILED_TO_START
  }
  case object EssentialContainerExited extends zio.aws.ecs.model.TaskStopCode {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.TaskStopCode =
      software.amazon.awssdk.services.ecs.model.TaskStopCode.ESSENTIAL_CONTAINER_EXITED
  }
  case object UserInitiated extends zio.aws.ecs.model.TaskStopCode {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.TaskStopCode =
      software.amazon.awssdk.services.ecs.model.TaskStopCode.USER_INITIATED
  }
}
