package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ServiceRegistry(
    registryArn: Option[String] = None,
    port: Option[BoxedInteger] = None,
    containerName: Option[String] = None,
    containerPort: Option[BoxedInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ServiceRegistry = {
    import ServiceRegistry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ServiceRegistry
      .builder()
      .optionallyWith(registryArn.map(value => value: java.lang.String))(
        _.registryArn
      )
      .optionallyWith(port.map(value => BoxedInteger.unwrap(value): Integer))(
        _.port
      )
      .optionallyWith(containerName.map(value => value: java.lang.String))(
        _.containerName
      )
      .optionallyWith(
        containerPort.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.containerPort)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ServiceRegistry.ReadOnly =
    zio.aws.ecs.model.ServiceRegistry.wrap(buildAwsValue())
}
object ServiceRegistry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ServiceRegistry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ServiceRegistry =
      zio.aws.ecs.model.ServiceRegistry(
        registryArn.map(value => value),
        port.map(value => value),
        containerName.map(value => value),
        containerPort.map(value => value)
      )
    def registryArn: Option[String]
    def port: Option[BoxedInteger]
    def containerName: Option[String]
    def containerPort: Option[BoxedInteger]
    def getRegistryArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("registryArn", registryArn)
    def getPort: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("port", port)
    def getContainerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerName", containerName)
    def getContainerPort: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("containerPort", containerPort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ServiceRegistry
  ) extends zio.aws.ecs.model.ServiceRegistry.ReadOnly {
    override val registryArn: Option[String] =
      scala.Option(impl.registryArn()).map(value => value: String)
    override val port: Option[BoxedInteger] = scala
      .Option(impl.port())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
    override val containerName: Option[String] =
      scala.Option(impl.containerName()).map(value => value: String)
    override val containerPort: Option[BoxedInteger] = scala
      .Option(impl.containerPort())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ServiceRegistry
  ): zio.aws.ecs.model.ServiceRegistry.ReadOnly = new Wrapper(impl)
}
