package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PortMapping(
    containerPort: Option[BoxedInteger] = None,
    hostPort: Option[BoxedInteger] = None,
    protocol: Option[zio.aws.ecs.model.TransportProtocol] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.PortMapping = {
    import PortMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.PortMapping
      .builder()
      .optionallyWith(
        containerPort.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.containerPort)
      .optionallyWith(
        hostPort.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.hostPort)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.PortMapping.ReadOnly =
    zio.aws.ecs.model.PortMapping.wrap(buildAwsValue())
}
object PortMapping {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.PortMapping] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.PortMapping =
      zio.aws.ecs.model.PortMapping(
        containerPort.map(value => value),
        hostPort.map(value => value),
        protocol.map(value => value)
      )
    def containerPort: Option[BoxedInteger]
    def hostPort: Option[BoxedInteger]
    def protocol: Option[zio.aws.ecs.model.TransportProtocol]
    def getContainerPort: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("containerPort", containerPort)
    def getHostPort: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("hostPort", hostPort)
    def getProtocol: ZIO[Any, AwsError, zio.aws.ecs.model.TransportProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.PortMapping
  ) extends zio.aws.ecs.model.PortMapping.ReadOnly {
    override val containerPort: Option[BoxedInteger] = scala
      .Option(impl.containerPort())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
    override val hostPort: Option[BoxedInteger] = scala
      .Option(impl.hostPort())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
    override val protocol: Option[zio.aws.ecs.model.TransportProtocol] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.ecs.model.TransportProtocol.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.PortMapping
  ): zio.aws.ecs.model.PortMapping.ReadOnly = new Wrapper(impl)
}
