package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait PlacementStrategyType {
  def unwrap: software.amazon.awssdk.services.ecs.model.PlacementStrategyType
}
object PlacementStrategyType {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.PlacementStrategyType
  ): zio.aws.ecs.model.PlacementStrategyType = value match {
    case software.amazon.awssdk.services.ecs.model.PlacementStrategyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.PlacementStrategyType.RANDOM =>
      val r = random
      r
    case software.amazon.awssdk.services.ecs.model.PlacementStrategyType.SPREAD =>
      val r = spread
      r
    case software.amazon.awssdk.services.ecs.model.PlacementStrategyType.BINPACK =>
      val r = binpack
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.PlacementStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.PlacementStrategyType =
      software.amazon.awssdk.services.ecs.model.PlacementStrategyType.UNKNOWN_TO_SDK_VERSION
  }
  case object random extends zio.aws.ecs.model.PlacementStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.PlacementStrategyType =
      software.amazon.awssdk.services.ecs.model.PlacementStrategyType.RANDOM
  }
  case object spread extends zio.aws.ecs.model.PlacementStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.PlacementStrategyType =
      software.amazon.awssdk.services.ecs.model.PlacementStrategyType.SPREAD
  }
  case object binpack extends zio.aws.ecs.model.PlacementStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.PlacementStrategyType =
      software.amazon.awssdk.services.ecs.model.PlacementStrategyType.BINPACK
  }
}
