package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTaskDefinitionsRequest(
    familyPrefix: Option[String] = None,
    status: Option[zio.aws.ecs.model.TaskDefinitionStatus] = None,
    sort: Option[zio.aws.ecs.model.SortOrder] = None,
    nextToken: Option[String] = None,
    maxResults: Option[BoxedInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest = {
    import ListTaskDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest
      .builder()
      .optionallyWith(familyPrefix.map(value => value: java.lang.String))(
        _.familyPrefix
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(sort.map(value => value.unwrap))(_.sort)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListTaskDefinitionsRequest.ReadOnly =
    zio.aws.ecs.model.ListTaskDefinitionsRequest.wrap(buildAwsValue())
}
object ListTaskDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListTaskDefinitionsRequest =
      zio.aws.ecs.model.ListTaskDefinitionsRequest(
        familyPrefix.map(value => value),
        status.map(value => value),
        sort.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def familyPrefix: Option[String]
    def status: Option[zio.aws.ecs.model.TaskDefinitionStatus]
    def sort: Option[zio.aws.ecs.model.SortOrder]
    def nextToken: Option[String]
    def maxResults: Option[BoxedInteger]
    def getFamilyPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("familyPrefix", familyPrefix)
    def getStatus: ZIO[Any, AwsError, zio.aws.ecs.model.TaskDefinitionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSort: ZIO[Any, AwsError, zio.aws.ecs.model.SortOrder] =
      AwsError.unwrapOptionField("sort", sort)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest
  ) extends zio.aws.ecs.model.ListTaskDefinitionsRequest.ReadOnly {
    override val familyPrefix: Option[String] =
      scala.Option(impl.familyPrefix()).map(value => value: String)
    override val status: Option[zio.aws.ecs.model.TaskDefinitionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ecs.model.TaskDefinitionStatus.wrap(value))
    override val sort: Option[zio.aws.ecs.model.SortOrder] = scala
      .Option(impl.sort())
      .map(value => zio.aws.ecs.model.SortOrder.wrap(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[BoxedInteger] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest
  ): zio.aws.ecs.model.ListTaskDefinitionsRequest.ReadOnly = new Wrapper(impl)
}
