package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InferenceAccelerator(deviceName: String, deviceType: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.InferenceAccelerator = {
    import InferenceAccelerator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.InferenceAccelerator
      .builder()
      .deviceName(deviceName: java.lang.String)
      .deviceType(deviceType: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.InferenceAccelerator.ReadOnly =
    zio.aws.ecs.model.InferenceAccelerator.wrap(buildAwsValue())
}
object InferenceAccelerator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.InferenceAccelerator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.InferenceAccelerator =
      zio.aws.ecs.model.InferenceAccelerator(deviceName, deviceType)
    def deviceName: String
    def deviceType: String
    def getDeviceName: ZIO[Any, Nothing, String] = ZIO.succeed(deviceName)
    def getDeviceType: ZIO[Any, Nothing, String] = ZIO.succeed(deviceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.InferenceAccelerator
  ) extends zio.aws.ecs.model.InferenceAccelerator.ReadOnly {
    override val deviceName: String = impl.deviceName(): String
    override val deviceType: String = impl.deviceType(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.InferenceAccelerator
  ): zio.aws.ecs.model.InferenceAccelerator.ReadOnly = new Wrapper(impl)
}
