package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeClustersRequest(
    clusters: Option[Iterable[String]] = None,
    include: Option[Iterable[zio.aws.ecs.model.ClusterField]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DescribeClustersRequest = {
    import DescribeClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DescribeClustersRequest
      .builder()
      .optionallyWith(
        clusters.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.clusters)
      .optionallyWith(
        include.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.includeWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DescribeClustersRequest.ReadOnly =
    zio.aws.ecs.model.DescribeClustersRequest.wrap(buildAwsValue())
}
object DescribeClustersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DescribeClustersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DescribeClustersRequest =
      zio.aws.ecs.model.DescribeClustersRequest(
        clusters.map(value => value),
        include.map(value => value)
      )
    def clusters: Option[List[String]]
    def include: Option[List[zio.aws.ecs.model.ClusterField]]
    def getClusters: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("clusters", clusters)
    def getInclude: ZIO[Any, AwsError, List[zio.aws.ecs.model.ClusterField]] =
      AwsError.unwrapOptionField("include", include)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DescribeClustersRequest
  ) extends zio.aws.ecs.model.DescribeClustersRequest.ReadOnly {
    override val clusters: Option[List[String]] = scala
      .Option(impl.clusters())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val include: Option[List[zio.aws.ecs.model.ClusterField]] = scala
      .Option(impl.include())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ClusterField.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DescribeClustersRequest
  ): zio.aws.ecs.model.DescribeClustersRequest.ReadOnly = new Wrapper(impl)
}
