package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateServiceResponse(
    service: Option[zio.aws.ecs.model.Service] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.CreateServiceResponse = {
    import CreateServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.CreateServiceResponse
      .builder()
      .optionallyWith(service.map(value => value.buildAwsValue()))(_.service)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.CreateServiceResponse.ReadOnly =
    zio.aws.ecs.model.CreateServiceResponse.wrap(buildAwsValue())
}
object CreateServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.CreateServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.CreateServiceResponse = zio.aws.ecs.model
      .CreateServiceResponse(service.map(value => value.asEditable))
    def service: Option[zio.aws.ecs.model.Service.ReadOnly]
    def getService: ZIO[Any, AwsError, zio.aws.ecs.model.Service.ReadOnly] =
      AwsError.unwrapOptionField("service", service)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.CreateServiceResponse
  ) extends zio.aws.ecs.model.CreateServiceResponse.ReadOnly {
    override val service: Option[zio.aws.ecs.model.Service.ReadOnly] = scala
      .Option(impl.service())
      .map(value => zio.aws.ecs.model.Service.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.CreateServiceResponse
  ): zio.aws.ecs.model.CreateServiceResponse.ReadOnly = new Wrapper(impl)
}
