package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait ClusterField {
  def unwrap: software.amazon.awssdk.services.ecs.model.ClusterField
}
object ClusterField {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.ClusterField
  ): zio.aws.ecs.model.ClusterField = value match {
    case software.amazon.awssdk.services.ecs.model.ClusterField.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.ClusterField.ATTACHMENTS =>
      val r = ATTACHMENTS
      r
    case software.amazon.awssdk.services.ecs.model.ClusterField.CONFIGURATIONS =>
      val r = CONFIGURATIONS
      r
    case software.amazon.awssdk.services.ecs.model.ClusterField.SETTINGS =>
      val r = SETTINGS
      r
    case software.amazon.awssdk.services.ecs.model.ClusterField.STATISTICS =>
      val r = STATISTICS
      r
    case software.amazon.awssdk.services.ecs.model.ClusterField.TAGS =>
      val r = TAGS
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.ClusterField {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ClusterField =
      software.amazon.awssdk.services.ecs.model.ClusterField.UNKNOWN_TO_SDK_VERSION
  }
  case object ATTACHMENTS extends zio.aws.ecs.model.ClusterField {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ClusterField =
      software.amazon.awssdk.services.ecs.model.ClusterField.ATTACHMENTS
  }
  case object CONFIGURATIONS extends zio.aws.ecs.model.ClusterField {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ClusterField =
      software.amazon.awssdk.services.ecs.model.ClusterField.CONFIGURATIONS
  }
  case object SETTINGS extends zio.aws.ecs.model.ClusterField {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ClusterField =
      software.amazon.awssdk.services.ecs.model.ClusterField.SETTINGS
  }
  case object STATISTICS extends zio.aws.ecs.model.ClusterField {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ClusterField =
      software.amazon.awssdk.services.ecs.model.ClusterField.STATISTICS
  }
  case object TAGS extends zio.aws.ecs.model.ClusterField {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ClusterField =
      software.amazon.awssdk.services.ecs.model.ClusterField.TAGS
  }
}
