package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.{
  ManagedScalingInstanceWarmupPeriod,
  ManagedScalingStepSize,
  ManagedScalingTargetCapacity
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ManagedScaling(
    status: Option[zio.aws.ecs.model.ManagedScalingStatus] = None,
    targetCapacity: Option[ManagedScalingTargetCapacity] = None,
    minimumScalingStepSize: Option[ManagedScalingStepSize] = None,
    maximumScalingStepSize: Option[ManagedScalingStepSize] = None,
    instanceWarmupPeriod: Option[ManagedScalingInstanceWarmupPeriod] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ManagedScaling = {
    import ManagedScaling.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ManagedScaling
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        targetCapacity.map(value =>
          ManagedScalingTargetCapacity.unwrap(value): Integer
        )
      )(_.targetCapacity)
      .optionallyWith(
        minimumScalingStepSize.map(value =>
          ManagedScalingStepSize.unwrap(value): Integer
        )
      )(_.minimumScalingStepSize)
      .optionallyWith(
        maximumScalingStepSize.map(value =>
          ManagedScalingStepSize.unwrap(value): Integer
        )
      )(_.maximumScalingStepSize)
      .optionallyWith(
        instanceWarmupPeriod.map(value =>
          ManagedScalingInstanceWarmupPeriod.unwrap(value): Integer
        )
      )(_.instanceWarmupPeriod)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ManagedScaling.ReadOnly =
    zio.aws.ecs.model.ManagedScaling.wrap(buildAwsValue())
}
object ManagedScaling {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ManagedScaling
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ManagedScaling =
      zio.aws.ecs.model.ManagedScaling(
        status.map(value => value),
        targetCapacity.map(value => value),
        minimumScalingStepSize.map(value => value),
        maximumScalingStepSize.map(value => value),
        instanceWarmupPeriod.map(value => value)
      )
    def status: Option[zio.aws.ecs.model.ManagedScalingStatus]
    def targetCapacity: Option[ManagedScalingTargetCapacity]
    def minimumScalingStepSize: Option[ManagedScalingStepSize]
    def maximumScalingStepSize: Option[ManagedScalingStepSize]
    def instanceWarmupPeriod: Option[ManagedScalingInstanceWarmupPeriod]
    def getStatus: ZIO[Any, AwsError, zio.aws.ecs.model.ManagedScalingStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTargetCapacity: ZIO[Any, AwsError, ManagedScalingTargetCapacity] =
      AwsError.unwrapOptionField("targetCapacity", targetCapacity)
    def getMinimumScalingStepSize: ZIO[Any, AwsError, ManagedScalingStepSize] =
      AwsError.unwrapOptionField(
        "minimumScalingStepSize",
        minimumScalingStepSize
      )
    def getMaximumScalingStepSize: ZIO[Any, AwsError, ManagedScalingStepSize] =
      AwsError.unwrapOptionField(
        "maximumScalingStepSize",
        maximumScalingStepSize
      )
    def getInstanceWarmupPeriod
        : ZIO[Any, AwsError, ManagedScalingInstanceWarmupPeriod] =
      AwsError.unwrapOptionField("instanceWarmupPeriod", instanceWarmupPeriod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ManagedScaling
  ) extends zio.aws.ecs.model.ManagedScaling.ReadOnly {
    override val status: Option[zio.aws.ecs.model.ManagedScalingStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ecs.model.ManagedScalingStatus.wrap(value))
    override val targetCapacity: Option[ManagedScalingTargetCapacity] = scala
      .Option(impl.targetCapacity())
      .map(value =>
        zio.aws.ecs.model.primitives.ManagedScalingTargetCapacity(value)
      )
    override val minimumScalingStepSize: Option[ManagedScalingStepSize] = scala
      .Option(impl.minimumScalingStepSize())
      .map(value => zio.aws.ecs.model.primitives.ManagedScalingStepSize(value))
    override val maximumScalingStepSize: Option[ManagedScalingStepSize] = scala
      .Option(impl.maximumScalingStepSize())
      .map(value => zio.aws.ecs.model.primitives.ManagedScalingStepSize(value))
    override val instanceWarmupPeriod
        : Option[ManagedScalingInstanceWarmupPeriod] = scala
      .Option(impl.instanceWarmupPeriod())
      .map(value =>
        zio.aws.ecs.model.primitives.ManagedScalingInstanceWarmupPeriod(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ManagedScaling
  ): zio.aws.ecs.model.ManagedScaling.ReadOnly = new Wrapper(impl)
}
