package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait ClusterSettingName {
  def unwrap: software.amazon.awssdk.services.ecs.model.ClusterSettingName
}
object ClusterSettingName {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.ClusterSettingName
  ): zio.aws.ecs.model.ClusterSettingName = value match {
    case software.amazon.awssdk.services.ecs.model.ClusterSettingName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.ClusterSettingName.CONTAINER_INSIGHTS =>
      val r = containerInsights
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.ClusterSettingName {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ClusterSettingName =
      software.amazon.awssdk.services.ecs.model.ClusterSettingName.UNKNOWN_TO_SDK_VERSION
  }
  case object containerInsights extends zio.aws.ecs.model.ClusterSettingName {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ClusterSettingName =
      software.amazon.awssdk.services.ecs.model.ClusterSettingName.CONTAINER_INSIGHTS
  }
}
