package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait FirelensConfigurationType {
  def unwrap
      : software.amazon.awssdk.services.ecs.model.FirelensConfigurationType
}
object FirelensConfigurationType {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.FirelensConfigurationType
  ): zio.aws.ecs.model.FirelensConfigurationType = value match {
    case software.amazon.awssdk.services.ecs.model.FirelensConfigurationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.FirelensConfigurationType.FLUENTD =>
      val r = fluentd
      r
    case software.amazon.awssdk.services.ecs.model.FirelensConfigurationType.FLUENTBIT =>
      val r = fluentbit
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.FirelensConfigurationType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.FirelensConfigurationType =
      software.amazon.awssdk.services.ecs.model.FirelensConfigurationType.UNKNOWN_TO_SDK_VERSION
  }
  case object fluentd extends zio.aws.ecs.model.FirelensConfigurationType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.FirelensConfigurationType =
      software.amazon.awssdk.services.ecs.model.FirelensConfigurationType.FLUENTD
  }
  case object fluentbit extends zio.aws.ecs.model.FirelensConfigurationType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.FirelensConfigurationType =
      software.amazon.awssdk.services.ecs.model.FirelensConfigurationType.FLUENTBIT
  }
}
