package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait EnvironmentFileType {
  def unwrap: software.amazon.awssdk.services.ecs.model.EnvironmentFileType
}
object EnvironmentFileType {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.EnvironmentFileType
  ): zio.aws.ecs.model.EnvironmentFileType = value match {
    case software.amazon.awssdk.services.ecs.model.EnvironmentFileType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.EnvironmentFileType.S3 =>
      val r = s3
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.EnvironmentFileType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.EnvironmentFileType =
      software.amazon.awssdk.services.ecs.model.EnvironmentFileType.UNKNOWN_TO_SDK_VERSION
  }
  case object s3 extends zio.aws.ecs.model.EnvironmentFileType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.EnvironmentFileType =
      software.amazon.awssdk.services.ecs.model.EnvironmentFileType.S3
  }
}
