package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TaskOverride(
    containerOverrides: Option[Iterable[zio.aws.ecs.model.ContainerOverride]] =
      None,
    cpu: Option[String] = None,
    inferenceAcceleratorOverrides: Option[
      Iterable[zio.aws.ecs.model.InferenceAcceleratorOverride]
    ] = None,
    executionRoleArn: Option[String] = None,
    memory: Option[String] = None,
    taskRoleArn: Option[String] = None,
    ephemeralStorage: Option[zio.aws.ecs.model.EphemeralStorage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.TaskOverride = {
    import TaskOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.TaskOverride
      .builder()
      .optionallyWith(
        containerOverrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containerOverrides)
      .optionallyWith(cpu.map(value => value: java.lang.String))(_.cpu)
      .optionallyWith(
        inferenceAcceleratorOverrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inferenceAcceleratorOverrides)
      .optionallyWith(executionRoleArn.map(value => value: java.lang.String))(
        _.executionRoleArn
      )
      .optionallyWith(memory.map(value => value: java.lang.String))(_.memory)
      .optionallyWith(taskRoleArn.map(value => value: java.lang.String))(
        _.taskRoleArn
      )
      .optionallyWith(ephemeralStorage.map(value => value.buildAwsValue()))(
        _.ephemeralStorage
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.TaskOverride.ReadOnly =
    zio.aws.ecs.model.TaskOverride.wrap(buildAwsValue())
}
object TaskOverride {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.TaskOverride] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.TaskOverride =
      zio.aws.ecs.model.TaskOverride(
        containerOverrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cpu.map(value => value),
        inferenceAcceleratorOverrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        executionRoleArn.map(value => value),
        memory.map(value => value),
        taskRoleArn.map(value => value),
        ephemeralStorage.map(value => value.asEditable)
      )
    def containerOverrides
        : Option[List[zio.aws.ecs.model.ContainerOverride.ReadOnly]]
    def cpu: Option[String]
    def inferenceAcceleratorOverrides
        : Option[List[zio.aws.ecs.model.InferenceAcceleratorOverride.ReadOnly]]
    def executionRoleArn: Option[String]
    def memory: Option[String]
    def taskRoleArn: Option[String]
    def ephemeralStorage: Option[zio.aws.ecs.model.EphemeralStorage.ReadOnly]
    def getContainerOverrides: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.ContainerOverride.ReadOnly
    ]] = AwsError.unwrapOptionField("containerOverrides", containerOverrides)
    def getCpu: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getInferenceAcceleratorOverrides: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.InferenceAcceleratorOverride.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "inferenceAcceleratorOverrides",
      inferenceAcceleratorOverrides
    )
    def getExecutionRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getMemory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("memory", memory)
    def getTaskRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskRoleArn", taskRoleArn)
    def getEphemeralStorage
        : ZIO[Any, AwsError, zio.aws.ecs.model.EphemeralStorage.ReadOnly] =
      AwsError.unwrapOptionField("ephemeralStorage", ephemeralStorage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.TaskOverride
  ) extends zio.aws.ecs.model.TaskOverride.ReadOnly {
    override val containerOverrides
        : Option[List[zio.aws.ecs.model.ContainerOverride.ReadOnly]] = scala
      .Option(impl.containerOverrides())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ContainerOverride.wrap(item)
        }.toList
      )
    override val cpu: Option[String] =
      scala.Option(impl.cpu()).map(value => value: String)
    override val inferenceAcceleratorOverrides: Option[
      List[zio.aws.ecs.model.InferenceAcceleratorOverride.ReadOnly]
    ] = scala
      .Option(impl.inferenceAcceleratorOverrides())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.InferenceAcceleratorOverride.wrap(item)
        }.toList
      )
    override val executionRoleArn: Option[String] =
      scala.Option(impl.executionRoleArn()).map(value => value: String)
    override val memory: Option[String] =
      scala.Option(impl.memory()).map(value => value: String)
    override val taskRoleArn: Option[String] =
      scala.Option(impl.taskRoleArn()).map(value => value: String)
    override val ephemeralStorage
        : Option[zio.aws.ecs.model.EphemeralStorage.ReadOnly] = scala
      .Option(impl.ephemeralStorage())
      .map(value => zio.aws.ecs.model.EphemeralStorage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.TaskOverride
  ): zio.aws.ecs.model.TaskOverride.ReadOnly = new Wrapper(impl)
}
