package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ManagedAgent(
    lastStartedAt: Option[Timestamp] = None,
    name: Option[zio.aws.ecs.model.ManagedAgentName] = None,
    reason: Option[String] = None,
    lastStatus: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ManagedAgent = {
    import ManagedAgent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ManagedAgent
      .builder()
      .optionallyWith(
        lastStartedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastStartedAt)
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .optionallyWith(lastStatus.map(value => value: java.lang.String))(
        _.lastStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ManagedAgent.ReadOnly =
    zio.aws.ecs.model.ManagedAgent.wrap(buildAwsValue())
}
object ManagedAgent {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.ManagedAgent] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ManagedAgent =
      zio.aws.ecs.model.ManagedAgent(
        lastStartedAt.map(value => value),
        name.map(value => value),
        reason.map(value => value),
        lastStatus.map(value => value)
      )
    def lastStartedAt: Option[Timestamp]
    def name: Option[zio.aws.ecs.model.ManagedAgentName]
    def reason: Option[String]
    def lastStatus: Option[String]
    def getLastStartedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastStartedAt", lastStartedAt)
    def getName: ZIO[Any, AwsError, zio.aws.ecs.model.ManagedAgentName] =
      AwsError.unwrapOptionField("name", name)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
    def getLastStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastStatus", lastStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ManagedAgent
  ) extends zio.aws.ecs.model.ManagedAgent.ReadOnly {
    override val lastStartedAt: Option[Timestamp] = scala
      .Option(impl.lastStartedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val name: Option[zio.aws.ecs.model.ManagedAgentName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ecs.model.ManagedAgentName.wrap(value))
    override val reason: Option[String] =
      scala.Option(impl.reason()).map(value => value: String)
    override val lastStatus: Option[String] =
      scala.Option(impl.lastStatus()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ManagedAgent
  ): zio.aws.ecs.model.ManagedAgent.ReadOnly = new Wrapper(impl)
}
