package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListServicesRequest(
    cluster: Option[String] = None,
    nextToken: Option[String] = None,
    maxResults: Option[BoxedInteger] = None,
    launchType: Option[zio.aws.ecs.model.LaunchType] = None,
    schedulingStrategy: Option[zio.aws.ecs.model.SchedulingStrategy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListServicesRequest = {
    import ListServicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListServicesRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .optionallyWith(schedulingStrategy.map(value => value.unwrap))(
        _.schedulingStrategy
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListServicesRequest.ReadOnly =
    zio.aws.ecs.model.ListServicesRequest.wrap(buildAwsValue())
}
object ListServicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListServicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListServicesRequest =
      zio.aws.ecs.model.ListServicesRequest(
        cluster.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        launchType.map(value => value),
        schedulingStrategy.map(value => value)
      )
    def cluster: Option[String]
    def nextToken: Option[String]
    def maxResults: Option[BoxedInteger]
    def launchType: Option[zio.aws.ecs.model.LaunchType]
    def schedulingStrategy: Option[zio.aws.ecs.model.SchedulingStrategy]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getLaunchType: ZIO[Any, AwsError, zio.aws.ecs.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getSchedulingStrategy
        : ZIO[Any, AwsError, zio.aws.ecs.model.SchedulingStrategy] =
      AwsError.unwrapOptionField("schedulingStrategy", schedulingStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListServicesRequest
  ) extends zio.aws.ecs.model.ListServicesRequest.ReadOnly {
    override val cluster: Option[String] =
      scala.Option(impl.cluster()).map(value => value: String)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[BoxedInteger] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
    override val launchType: Option[zio.aws.ecs.model.LaunchType] = scala
      .Option(impl.launchType())
      .map(value => zio.aws.ecs.model.LaunchType.wrap(value))
    override val schedulingStrategy
        : Option[zio.aws.ecs.model.SchedulingStrategy] = scala
      .Option(impl.schedulingStrategy())
      .map(value => zio.aws.ecs.model.SchedulingStrategy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListServicesRequest
  ): zio.aws.ecs.model.ListServicesRequest.ReadOnly = new Wrapper(impl)
}
