package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnvironmentFile(
    value: String,
    `type`: zio.aws.ecs.model.EnvironmentFileType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.EnvironmentFile = {
    import EnvironmentFile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.EnvironmentFile
      .builder()
      .value(value: java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.EnvironmentFile.ReadOnly =
    zio.aws.ecs.model.EnvironmentFile.wrap(buildAwsValue())
}
object EnvironmentFile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.EnvironmentFile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.EnvironmentFile =
      zio.aws.ecs.model.EnvironmentFile(value, `type`)
    def value: String
    def `type`: zio.aws.ecs.model.EnvironmentFileType
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
    def getType: ZIO[Any, Nothing, zio.aws.ecs.model.EnvironmentFileType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.EnvironmentFile
  ) extends zio.aws.ecs.model.EnvironmentFile.ReadOnly {
    override val value: String = impl.value(): String
    override val `type`: zio.aws.ecs.model.EnvironmentFileType =
      zio.aws.ecs.model.EnvironmentFileType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.EnvironmentFile
  ): zio.aws.ecs.model.EnvironmentFile.ReadOnly = new Wrapper(impl)
}
