package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateCapacityProviderResponse(
    capacityProvider: Option[zio.aws.ecs.model.CapacityProvider] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.CreateCapacityProviderResponse = {
    import CreateCapacityProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.CreateCapacityProviderResponse
      .builder()
      .optionallyWith(capacityProvider.map(value => value.buildAwsValue()))(
        _.capacityProvider
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.CreateCapacityProviderResponse.ReadOnly =
    zio.aws.ecs.model.CreateCapacityProviderResponse.wrap(buildAwsValue())
}
object CreateCapacityProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.CreateCapacityProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.CreateCapacityProviderResponse =
      zio.aws.ecs.model.CreateCapacityProviderResponse(
        capacityProvider.map(value => value.asEditable)
      )
    def capacityProvider: Option[zio.aws.ecs.model.CapacityProvider.ReadOnly]
    def getCapacityProvider
        : ZIO[Any, AwsError, zio.aws.ecs.model.CapacityProvider.ReadOnly] =
      AwsError.unwrapOptionField("capacityProvider", capacityProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.CreateCapacityProviderResponse
  ) extends zio.aws.ecs.model.CreateCapacityProviderResponse.ReadOnly {
    override val capacityProvider
        : Option[zio.aws.ecs.model.CapacityProvider.ReadOnly] = scala
      .Option(impl.capacityProvider())
      .map(value => zio.aws.ecs.model.CapacityProvider.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.CreateCapacityProviderResponse
  ): zio.aws.ecs.model.CreateCapacityProviderResponse.ReadOnly = new Wrapper(
    impl
  )
}
