package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ContainerOverride(
    name: Option[String] = None,
    command: Option[Iterable[String]] = None,
    environment: Option[Iterable[zio.aws.ecs.model.KeyValuePair]] = None,
    environmentFiles: Option[Iterable[zio.aws.ecs.model.EnvironmentFile]] =
      None,
    cpu: Option[BoxedInteger] = None,
    memory: Option[BoxedInteger] = None,
    memoryReservation: Option[BoxedInteger] = None,
    resourceRequirements: Option[
      Iterable[zio.aws.ecs.model.ResourceRequirement]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ContainerOverride = {
    import ContainerOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ContainerOverride
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(
        environment.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environment)
      .optionallyWith(
        environmentFiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentFiles)
      .optionallyWith(cpu.map(value => BoxedInteger.unwrap(value): Integer))(
        _.cpu
      )
      .optionallyWith(memory.map(value => BoxedInteger.unwrap(value): Integer))(
        _.memory
      )
      .optionallyWith(
        memoryReservation.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.memoryReservation)
      .optionallyWith(
        resourceRequirements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceRequirements)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ContainerOverride.ReadOnly =
    zio.aws.ecs.model.ContainerOverride.wrap(buildAwsValue())
}
object ContainerOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ContainerOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ContainerOverride =
      zio.aws.ecs.model.ContainerOverride(
        name.map(value => value),
        command.map(value => value),
        environment.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        environmentFiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cpu.map(value => value),
        memory.map(value => value),
        memoryReservation.map(value => value),
        resourceRequirements.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Option[String]
    def command: Option[List[String]]
    def environment: Option[List[zio.aws.ecs.model.KeyValuePair.ReadOnly]]
    def environmentFiles
        : Option[List[zio.aws.ecs.model.EnvironmentFile.ReadOnly]]
    def cpu: Option[BoxedInteger]
    def memory: Option[BoxedInteger]
    def memoryReservation: Option[BoxedInteger]
    def resourceRequirements
        : Option[List[zio.aws.ecs.model.ResourceRequirement.ReadOnly]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getCommand: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("command", command)
    def getEnvironment
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.KeyValuePair.ReadOnly]] =
      AwsError.unwrapOptionField("environment", environment)
    def getEnvironmentFiles
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.EnvironmentFile.ReadOnly]] =
      AwsError.unwrapOptionField("environmentFiles", environmentFiles)
    def getCpu: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getMemory: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("memory", memory)
    def getMemoryReservation: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("memoryReservation", memoryReservation)
    def getResourceRequirements: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.ResourceRequirement.ReadOnly
    ]] =
      AwsError.unwrapOptionField("resourceRequirements", resourceRequirements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ContainerOverride
  ) extends zio.aws.ecs.model.ContainerOverride.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val command: Option[List[String]] = scala
      .Option(impl.command())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val environment
        : Option[List[zio.aws.ecs.model.KeyValuePair.ReadOnly]] = scala
      .Option(impl.environment())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.KeyValuePair.wrap(item)
        }.toList
      )
    override val environmentFiles
        : Option[List[zio.aws.ecs.model.EnvironmentFile.ReadOnly]] = scala
      .Option(impl.environmentFiles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.EnvironmentFile.wrap(item)
        }.toList
      )
    override val cpu: Option[BoxedInteger] = scala
      .Option(impl.cpu())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
    override val memory: Option[BoxedInteger] = scala
      .Option(impl.memory())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
    override val memoryReservation: Option[BoxedInteger] = scala
      .Option(impl.memoryReservation())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
    override val resourceRequirements
        : Option[List[zio.aws.ecs.model.ResourceRequirement.ReadOnly]] = scala
      .Option(impl.resourceRequirements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ResourceRequirement.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ContainerOverride
  ): zio.aws.ecs.model.ContainerOverride.ReadOnly = new Wrapper(impl)
}
