package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Container(
    containerArn: Option[String] = None,
    taskArn: Option[String] = None,
    name: Option[String] = None,
    image: Option[String] = None,
    imageDigest: Option[String] = None,
    runtimeId: Option[String] = None,
    lastStatus: Option[String] = None,
    exitCode: Option[BoxedInteger] = None,
    reason: Option[String] = None,
    networkBindings: Option[Iterable[zio.aws.ecs.model.NetworkBinding]] = None,
    networkInterfaces: Option[Iterable[zio.aws.ecs.model.NetworkInterface]] =
      None,
    healthStatus: Option[zio.aws.ecs.model.HealthStatus] = None,
    managedAgents: Option[Iterable[zio.aws.ecs.model.ManagedAgent]] = None,
    cpu: Option[String] = None,
    memory: Option[String] = None,
    memoryReservation: Option[String] = None,
    gpuIds: Option[Iterable[String]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Container = {
    import Container.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Container
      .builder()
      .optionallyWith(containerArn.map(value => value: java.lang.String))(
        _.containerArn
      )
      .optionallyWith(taskArn.map(value => value: java.lang.String))(_.taskArn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(image.map(value => value: java.lang.String))(_.image)
      .optionallyWith(imageDigest.map(value => value: java.lang.String))(
        _.imageDigest
      )
      .optionallyWith(runtimeId.map(value => value: java.lang.String))(
        _.runtimeId
      )
      .optionallyWith(lastStatus.map(value => value: java.lang.String))(
        _.lastStatus
      )
      .optionallyWith(
        exitCode.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.exitCode)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .optionallyWith(
        networkBindings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkBindings)
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(healthStatus.map(value => value.unwrap))(_.healthStatus)
      .optionallyWith(
        managedAgents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedAgents)
      .optionallyWith(cpu.map(value => value: java.lang.String))(_.cpu)
      .optionallyWith(memory.map(value => value: java.lang.String))(_.memory)
      .optionallyWith(memoryReservation.map(value => value: java.lang.String))(
        _.memoryReservation
      )
      .optionallyWith(
        gpuIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.gpuIds)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Container.ReadOnly =
    zio.aws.ecs.model.Container.wrap(buildAwsValue())
}
object Container {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Container] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Container = zio.aws.ecs.model.Container(
      containerArn.map(value => value),
      taskArn.map(value => value),
      name.map(value => value),
      image.map(value => value),
      imageDigest.map(value => value),
      runtimeId.map(value => value),
      lastStatus.map(value => value),
      exitCode.map(value => value),
      reason.map(value => value),
      networkBindings.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      networkInterfaces.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      healthStatus.map(value => value),
      managedAgents.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      cpu.map(value => value),
      memory.map(value => value),
      memoryReservation.map(value => value),
      gpuIds.map(value => value)
    )
    def containerArn: Option[String]
    def taskArn: Option[String]
    def name: Option[String]
    def image: Option[String]
    def imageDigest: Option[String]
    def runtimeId: Option[String]
    def lastStatus: Option[String]
    def exitCode: Option[BoxedInteger]
    def reason: Option[String]
    def networkBindings: Option[List[zio.aws.ecs.model.NetworkBinding.ReadOnly]]
    def networkInterfaces
        : Option[List[zio.aws.ecs.model.NetworkInterface.ReadOnly]]
    def healthStatus: Option[zio.aws.ecs.model.HealthStatus]
    def managedAgents: Option[List[zio.aws.ecs.model.ManagedAgent.ReadOnly]]
    def cpu: Option[String]
    def memory: Option[String]
    def memoryReservation: Option[String]
    def gpuIds: Option[List[String]]
    def getContainerArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerArn", containerArn)
    def getTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskArn", taskArn)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getImage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("image", image)
    def getImageDigest: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageDigest", imageDigest)
    def getRuntimeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("runtimeId", runtimeId)
    def getLastStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastStatus", lastStatus)
    def getExitCode: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("exitCode", exitCode)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
    def getNetworkBindings
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.NetworkBinding.ReadOnly]] =
      AwsError.unwrapOptionField("networkBindings", networkBindings)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.NetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getHealthStatus: ZIO[Any, AwsError, zio.aws.ecs.model.HealthStatus] =
      AwsError.unwrapOptionField("healthStatus", healthStatus)
    def getManagedAgents
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ManagedAgent.ReadOnly]] =
      AwsError.unwrapOptionField("managedAgents", managedAgents)
    def getCpu: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getMemory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("memory", memory)
    def getMemoryReservation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("memoryReservation", memoryReservation)
    def getGpuIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("gpuIds", gpuIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Container
  ) extends zio.aws.ecs.model.Container.ReadOnly {
    override val containerArn: Option[String] =
      scala.Option(impl.containerArn()).map(value => value: String)
    override val taskArn: Option[String] =
      scala.Option(impl.taskArn()).map(value => value: String)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val image: Option[String] =
      scala.Option(impl.image()).map(value => value: String)
    override val imageDigest: Option[String] =
      scala.Option(impl.imageDigest()).map(value => value: String)
    override val runtimeId: Option[String] =
      scala.Option(impl.runtimeId()).map(value => value: String)
    override val lastStatus: Option[String] =
      scala.Option(impl.lastStatus()).map(value => value: String)
    override val exitCode: Option[BoxedInteger] = scala
      .Option(impl.exitCode())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
    override val reason: Option[String] =
      scala.Option(impl.reason()).map(value => value: String)
    override val networkBindings
        : Option[List[zio.aws.ecs.model.NetworkBinding.ReadOnly]] = scala
      .Option(impl.networkBindings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.NetworkBinding.wrap(item)
        }.toList
      )
    override val networkInterfaces
        : Option[List[zio.aws.ecs.model.NetworkInterface.ReadOnly]] = scala
      .Option(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.NetworkInterface.wrap(item)
        }.toList
      )
    override val healthStatus: Option[zio.aws.ecs.model.HealthStatus] = scala
      .Option(impl.healthStatus())
      .map(value => zio.aws.ecs.model.HealthStatus.wrap(value))
    override val managedAgents
        : Option[List[zio.aws.ecs.model.ManagedAgent.ReadOnly]] = scala
      .Option(impl.managedAgents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ManagedAgent.wrap(item)
        }.toList
      )
    override val cpu: Option[String] =
      scala.Option(impl.cpu()).map(value => value: String)
    override val memory: Option[String] =
      scala.Option(impl.memory()).map(value => value: String)
    override val memoryReservation: Option[String] =
      scala.Option(impl.memoryReservation()).map(value => value: String)
    override val gpuIds: Option[List[String]] = scala
      .Option(impl.gpuIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Container
  ): zio.aws.ecs.model.Container.ReadOnly = new Wrapper(impl)
}
