package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoadBalancer(
    targetGroupArn: Option[String] = None,
    loadBalancerName: Option[String] = None,
    containerName: Option[String] = None,
    containerPort: Option[BoxedInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.LoadBalancer = {
    import LoadBalancer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.LoadBalancer
      .builder()
      .optionallyWith(targetGroupArn.map(value => value: java.lang.String))(
        _.targetGroupArn
      )
      .optionallyWith(loadBalancerName.map(value => value: java.lang.String))(
        _.loadBalancerName
      )
      .optionallyWith(containerName.map(value => value: java.lang.String))(
        _.containerName
      )
      .optionallyWith(
        containerPort.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.containerPort)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.LoadBalancer.ReadOnly =
    zio.aws.ecs.model.LoadBalancer.wrap(buildAwsValue())
}
object LoadBalancer {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.LoadBalancer] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.LoadBalancer =
      zio.aws.ecs.model.LoadBalancer(
        targetGroupArn.map(value => value),
        loadBalancerName.map(value => value),
        containerName.map(value => value),
        containerPort.map(value => value)
      )
    def targetGroupArn: Option[String]
    def loadBalancerName: Option[String]
    def containerName: Option[String]
    def containerPort: Option[BoxedInteger]
    def getTargetGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetGroupArn", targetGroupArn)
    def getLoadBalancerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("loadBalancerName", loadBalancerName)
    def getContainerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerName", containerName)
    def getContainerPort: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("containerPort", containerPort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.LoadBalancer
  ) extends zio.aws.ecs.model.LoadBalancer.ReadOnly {
    override val targetGroupArn: Option[String] =
      scala.Option(impl.targetGroupArn()).map(value => value: String)
    override val loadBalancerName: Option[String] =
      scala.Option(impl.loadBalancerName()).map(value => value: String)
    override val containerName: Option[String] =
      scala.Option(impl.containerName()).map(value => value: String)
    override val containerPort: Option[BoxedInteger] = scala
      .Option(impl.containerPort())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.LoadBalancer
  ): zio.aws.ecs.model.LoadBalancer.ReadOnly = new Wrapper(impl)
}
