package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListServicesResponse(
    serviceArns: Option[Iterable[String]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListServicesResponse = {
    import ListServicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListServicesResponse
      .builder()
      .optionallyWith(
        serviceArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.serviceArns)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListServicesResponse.ReadOnly =
    zio.aws.ecs.model.ListServicesResponse.wrap(buildAwsValue())
}
object ListServicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListServicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListServicesResponse =
      zio.aws.ecs.model.ListServicesResponse(
        serviceArns.map(value => value),
        nextToken.map(value => value)
      )
    def serviceArns: Option[List[String]]
    def nextToken: Option[String]
    def getServiceArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("serviceArns", serviceArns)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListServicesResponse
  ) extends zio.aws.ecs.model.ListServicesResponse.ReadOnly {
    override val serviceArns: Option[List[String]] = scala
      .Option(impl.serviceArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListServicesResponse
  ): zio.aws.ecs.model.ListServicesResponse.ReadOnly = new Wrapper(impl)
}
