package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExecuteCommandRequest(
    cluster: Option[String] = None,
    container: Option[String] = None,
    command: String,
    interactive: Boolean,
    task: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ExecuteCommandRequest = {
    import ExecuteCommandRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ExecuteCommandRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .optionallyWith(container.map(value => value: java.lang.String))(
        _.container
      )
      .command(command: java.lang.String)
      .interactive(interactive: java.lang.Boolean)
      .task(task: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ExecuteCommandRequest.ReadOnly =
    zio.aws.ecs.model.ExecuteCommandRequest.wrap(buildAwsValue())
}
object ExecuteCommandRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ExecuteCommandRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ExecuteCommandRequest =
      zio.aws.ecs.model.ExecuteCommandRequest(
        cluster.map(value => value),
        container.map(value => value),
        command,
        interactive,
        task
      )
    def cluster: Option[String]
    def container: Option[String]
    def command: String
    def interactive: Boolean
    def task: String
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getContainer: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("container", container)
    def getCommand: ZIO[Any, Nothing, String] = ZIO.succeed(command)
    def getInteractive: ZIO[Any, Nothing, Boolean] = ZIO.succeed(interactive)
    def getTask: ZIO[Any, Nothing, String] = ZIO.succeed(task)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ExecuteCommandRequest
  ) extends zio.aws.ecs.model.ExecuteCommandRequest.ReadOnly {
    override val cluster: Option[String] =
      scala.Option(impl.cluster()).map(value => value: String)
    override val container: Option[String] =
      scala.Option(impl.container()).map(value => value: String)
    override val command: String = impl.command(): String
    override val interactive: Boolean = impl.interactive(): Boolean
    override val task: String = impl.task(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ExecuteCommandRequest
  ): zio.aws.ecs.model.ExecuteCommandRequest.ReadOnly = new Wrapper(impl)
}
