package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EphemeralStorage(sizeInGiB: Integer) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.EphemeralStorage = {
    import EphemeralStorage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.EphemeralStorage
      .builder()
      .sizeInGiB(Integer.unwrap(sizeInGiB): java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.EphemeralStorage.ReadOnly =
    zio.aws.ecs.model.EphemeralStorage.wrap(buildAwsValue())
}
object EphemeralStorage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.EphemeralStorage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.EphemeralStorage =
      zio.aws.ecs.model.EphemeralStorage(sizeInGiB)
    def sizeInGiB: Integer
    def getSizeInGiB: ZIO[Any, Nothing, Integer] = ZIO.succeed(sizeInGiB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.EphemeralStorage
  ) extends zio.aws.ecs.model.EphemeralStorage.ReadOnly {
    override val sizeInGiB: Integer =
      zio.aws.ecs.model.primitives.Integer(impl.sizeInGiB())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.EphemeralStorage
  ): zio.aws.ecs.model.EphemeralStorage.ReadOnly = new Wrapper(impl)
}
