package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait LogDriver {
  def unwrap: software.amazon.awssdk.services.ecs.model.LogDriver
}
object LogDriver {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.LogDriver
  ): zio.aws.ecs.model.LogDriver = value match {
    case software.amazon.awssdk.services.ecs.model.LogDriver.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.LogDriver.JSON_FILE =>
      val r = `json-file`
      r
    case software.amazon.awssdk.services.ecs.model.LogDriver.SYSLOG =>
      val r = syslog
      r
    case software.amazon.awssdk.services.ecs.model.LogDriver.JOURNALD =>
      val r = journald
      r
    case software.amazon.awssdk.services.ecs.model.LogDriver.GELF =>
      val r = gelf
      r
    case software.amazon.awssdk.services.ecs.model.LogDriver.FLUENTD =>
      val r = fluentd
      r
    case software.amazon.awssdk.services.ecs.model.LogDriver.AWSLOGS =>
      val r = awslogs
      r
    case software.amazon.awssdk.services.ecs.model.LogDriver.SPLUNK =>
      val r = splunk
      r
    case software.amazon.awssdk.services.ecs.model.LogDriver.AWSFIRELENS =>
      val r = awsfirelens
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.LogDriver {
    override def unwrap: software.amazon.awssdk.services.ecs.model.LogDriver =
      software.amazon.awssdk.services.ecs.model.LogDriver.UNKNOWN_TO_SDK_VERSION
  }
  case object `json-file` extends zio.aws.ecs.model.LogDriver {
    override def unwrap: software.amazon.awssdk.services.ecs.model.LogDriver =
      software.amazon.awssdk.services.ecs.model.LogDriver.JSON_FILE
  }
  case object syslog extends zio.aws.ecs.model.LogDriver {
    override def unwrap: software.amazon.awssdk.services.ecs.model.LogDriver =
      software.amazon.awssdk.services.ecs.model.LogDriver.SYSLOG
  }
  case object journald extends zio.aws.ecs.model.LogDriver {
    override def unwrap: software.amazon.awssdk.services.ecs.model.LogDriver =
      software.amazon.awssdk.services.ecs.model.LogDriver.JOURNALD
  }
  case object gelf extends zio.aws.ecs.model.LogDriver {
    override def unwrap: software.amazon.awssdk.services.ecs.model.LogDriver =
      software.amazon.awssdk.services.ecs.model.LogDriver.GELF
  }
  case object fluentd extends zio.aws.ecs.model.LogDriver {
    override def unwrap: software.amazon.awssdk.services.ecs.model.LogDriver =
      software.amazon.awssdk.services.ecs.model.LogDriver.FLUENTD
  }
  case object awslogs extends zio.aws.ecs.model.LogDriver {
    override def unwrap: software.amazon.awssdk.services.ecs.model.LogDriver =
      software.amazon.awssdk.services.ecs.model.LogDriver.AWSLOGS
  }
  case object splunk extends zio.aws.ecs.model.LogDriver {
    override def unwrap: software.amazon.awssdk.services.ecs.model.LogDriver =
      software.amazon.awssdk.services.ecs.model.LogDriver.SPLUNK
  }
  case object awsfirelens extends zio.aws.ecs.model.LogDriver {
    override def unwrap: software.amazon.awssdk.services.ecs.model.LogDriver =
      software.amazon.awssdk.services.ecs.model.LogDriver.AWSFIRELENS
  }
}
